/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.writer;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import uk.me.parabola.splitter.Area;
import uk.me.parabola.splitter.Element;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.Relation;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.Way;
import uk.me.parabola.splitter.writer.OSMWriter;

public abstract class AbstractOSMWriter
implements OSMWriter {
    public static final int REMOVE_VERSION = 1;
    public static final int FAKE_VERSION = 2;
    public static final int KEEP_VERSION = 3;
    protected final Area bounds;
    protected final Area extendedBounds;
    protected final File outputDir;
    protected final int mapId;
    protected final Rectangle bbox;
    protected int versionMethod;

    protected AbstractOSMWriter(Area bounds, File outputDir, int mapId, int extra) {
        this.mapId = mapId;
        this.bounds = bounds;
        this.outputDir = outputDir;
        this.extendedBounds = new Area(bounds.getMinLat() - extra, bounds.getMinLong() - extra, bounds.getMaxLat() + extra, bounds.getMaxLong() + extra);
        this.bbox = Utils.area2Rectangle(bounds, 1);
    }

    public void setVersionMethod(int versionMethod) {
        this.versionMethod = versionMethod;
    }

    protected int getWriteVersion(Element el) {
        if (this.versionMethod == 1) {
            return 0;
        }
        if (this.versionMethod == 2) {
            return 1;
        }
        return el.getVersion();
    }

    @Override
    public Area getBounds() {
        return this.bounds;
    }

    @Override
    public Area getExtendedBounds() {
        return this.extendedBounds;
    }

    @Override
    public int getMapId() {
        return this.mapId;
    }

    @Override
    public Rectangle getBBox() {
        return this.bbox;
    }

    @Override
    public void write(Element element) throws IOException {
        if (element instanceof Node) {
            this.write((Node)element);
        } else if (element instanceof Way) {
            this.write((Way)element);
        } else if (element instanceof Relation) {
            this.write((Relation)element);
        }
    }
}

