/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter.tools;

import java.util.Arrays;

public class BitWriter {
    private byte[] buf;
    private int bufsize;
    private int usedBits;
    private int index;
    private static final int BUFSIZE_INC = 50;
    private static final int INITIAL_BUF_SIZE = 20;

    public BitWriter(int sizeInBytes) {
        this.bufsize = sizeInBytes;
        this.buf = new byte[this.bufsize];
    }

    public BitWriter() {
        this(20);
    }

    public void clear() {
        Arrays.fill(this.buf, (byte)0);
        this.index = 0;
        this.usedBits = 0;
    }

    private void put1(int b) {
        this.ensureSize(this.index + 1);
        int rem = this.usedBits++;
        int n = this.index++;
        this.buf[n] = (byte)(this.buf[n] | (b & 1) << rem);
        if (this.usedBits == 8) {
            this.usedBits = 0;
        }
    }

    public void put1(boolean b) {
        this.put1(b ? 1 : 0);
    }

    public void putn(int bval, int nb) {
        int nput;
        int n;
        assert (nb >= 1 && nb <= 32);
        int val = nb < 32 ? bval & (1 << nb) - 1 : bval;
        this.ensureSize(this.index + (this.usedBits + n + 7) / 8);
        int rem = this.usedBits;
        for (n = nb; n > 0; n -= nput) {
            int n2 = this.index;
            this.buf[n2] = (byte)(this.buf[n2] | val << rem & 0xFF);
            nput = 8 - rem;
            if (nput > n) {
                nput = n;
            }
            this.usedBits += nput;
            if (this.usedBits >= 8) {
                ++this.index;
                this.usedBits = 0;
            }
            val >>>= nput;
            rem = 0;
        }
    }

    public void sputn(int bval, int nb) {
        assert (nb > 1 && nb <= 32);
        int top = 1 << nb - 1;
        if (bval < 0) {
            assert (-bval < top || top < 0);
            int v = top + bval | top;
            this.putn(v, nb);
        } else {
            assert (bval < top || top < 0);
            this.putn(bval, nb);
        }
    }

    public void sputn2(int bval, int nb) {
        assert (nb > 1 && nb <= 32);
        int top = 1 << nb - 1;
        int mask = top - 1;
        int val = Math.abs(bval);
        if (bval == Integer.MIN_VALUE) {
            this.putn(top, nb);
            val = Math.abs(val - mask);
        }
        assert (val >= 0);
        while (val > mask) {
            this.putn(top, nb);
            val -= mask;
        }
        if (bval < 0) {
            this.putn(top - val | top, nb);
        } else {
            this.putn(val, nb);
        }
    }

    public byte[] getBytes() {
        return this.buf;
    }

    public int getBitPosition() {
        return this.index * 8 + this.usedBits;
    }

    public int getLength() {
        if (this.usedBits == 0) {
            return this.index;
        }
        return this.index + 1;
    }

    private void ensureSize(int newlen) {
        if (newlen >= this.bufsize) {
            this.reallocBuffer();
        }
    }

    private void reallocBuffer() {
        this.bufsize += 50;
        this.buf = Arrays.copyOf(this.buf, this.bufsize);
    }
}

