/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import uk.me.parabola.splitter.AbstractMapProcessor;
import uk.me.parabola.splitter.AreaDictionary;
import uk.me.parabola.splitter.AreaGridResult;
import uk.me.parabola.splitter.AreaIndex;
import uk.me.parabola.splitter.AreaSet;
import uk.me.parabola.splitter.DataStorer;
import uk.me.parabola.splitter.Element;
import uk.me.parabola.splitter.Node;
import uk.me.parabola.splitter.Relation;
import uk.me.parabola.splitter.SplitFailedException;
import uk.me.parabola.splitter.Utils;
import uk.me.parabola.splitter.Way;
import uk.me.parabola.splitter.args.SplitterParams;
import uk.me.parabola.splitter.tools.Long2IntClosedMapFunction;
import uk.me.parabola.splitter.tools.SparseLong2IntMap;
import uk.me.parabola.splitter.writer.OSMWriter;

class SplitProcessor
extends AbstractMapProcessor {
    private final OSMWriter[] writers;
    private SparseLong2IntMap coords;
    private SparseLong2IntMap ways;
    private final AreaDictionary writerDictionary;
    private final DataStorer dataStorer;
    private final Long2IntClosedMapFunction nodeWriterMap;
    private final Long2IntClosedMapFunction wayWriterMap;
    private final Long2IntClosedMapFunction relWriterMap;
    private long countQuickTest;
    private long countFullTest;
    private long countCoords;
    private long countWays;
    private final int writerOffset;
    private final int lastWriter;
    private final AreaIndex writerIndex;
    private final int maxThreads;
    private final InputQueueInfo[] writerInputQueues;
    protected final BlockingQueue<InputQueueInfo> toProcess;
    private final ArrayList<Thread> workerThreads;
    protected final InputQueueInfo stopMsg = new InputQueueInfo(null);
    private AreaSet usedWriters;
    private boolean seenWay;
    private boolean seenRel;
    static final int NO_ELEMENTS = 3;
    static final int STAGING_SIZE = 300;

    SplitProcessor(DataStorer dataStorer, int writerOffset, int numWritersThisPass, SplitterParams mainOptions) {
        this.dataStorer = dataStorer;
        this.writerDictionary = dataStorer.getAreaDictionary();
        this.writers = dataStorer.getWriters();
        this.coords = new SparseLong2IntMap("coord");
        this.ways = new SparseLong2IntMap("way");
        this.coords.defaultReturnValue(Short.MIN_VALUE);
        this.ways.defaultReturnValue(Short.MIN_VALUE);
        this.writerIndex = dataStorer.getGrid();
        this.countWays = this.ways.size();
        this.writerOffset = writerOffset;
        this.lastWriter = writerOffset + numWritersThisPass - 1;
        this.maxThreads = mainOptions.getMaxThreads().getCount();
        this.toProcess = new ArrayBlockingQueue<InputQueueInfo>(numWritersThisPass);
        this.writerInputQueues = new InputQueueInfo[numWritersThisPass];
        for (int i = 0; i < this.writerInputQueues.length; ++i) {
            this.writerInputQueues[i] = new InputQueueInfo(this.writers[i + writerOffset]);
            this.writers[i + writerOffset].initForWrite();
        }
        this.nodeWriterMap = dataStorer.getWriterMap(0);
        this.wayWriterMap = dataStorer.getWriterMap(1);
        this.relWriterMap = dataStorer.getWriterMap(2);
        this.usedWriters = new AreaSet();
        int noOfWorkerThreads = Math.min(this.maxThreads - 1, numWritersThisPass);
        this.workerThreads = new ArrayList(noOfWorkerThreads);
        for (int i = 0; i < noOfWorkerThreads; ++i) {
            Thread worker = new Thread(new OSMWriterWorker());
            worker.setName("worker-" + i);
            this.workerThreads.add(worker);
            worker.start();
        }
    }

    private void setUsedWriters(int multiTileWriterIdx) {
        if (multiTileWriterIdx != Short.MIN_VALUE) {
            AreaSet cl = this.writerDictionary.getSet(multiTileWriterIdx);
            for (int i : cl) {
                if (i < this.writerOffset || i > this.lastWriter) continue;
                this.usedWriters.set(i);
            }
        }
    }

    @Override
    public void processNode(Node n) {
        try {
            this.writeNode(n);
        }
        catch (IOException e) {
            throw new SplitFailedException("failed to write node " + n.getId(), e);
        }
    }

    @Override
    public void processWay(Way w) {
        int multiTileWriterIdx;
        this.usedWriters.clear();
        int n = multiTileWriterIdx = this.wayWriterMap != null ? this.wayWriterMap.getSeq(w.getId()) : Short.MIN_VALUE;
        if (multiTileWriterIdx != Short.MIN_VALUE) {
            this.setUsedWriters(multiTileWriterIdx);
        } else {
            int oldclIndex = Short.MIN_VALUE;
            LongListIterator longListIterator = w.getRefs().iterator();
            while (longListIterator.hasNext()) {
                long id = (Long)longListIterator.next();
                int clIdx = this.coords.get(id);
                if (clIdx == Short.MIN_VALUE || oldclIndex == clIdx) continue;
                this.usedWriters.or(this.writerDictionary.getSet(clIdx));
                if (this.wayWriterMap != null) break;
                oldclIndex = clIdx;
            }
        }
        if (!this.usedWriters.isEmpty()) {
            this.ways.put(w.getId(), this.writerDictionary.translate(this.usedWriters));
            ++this.countWays;
            if (this.countWays % 10000000L == 0L) {
                System.out.println("  Number of stored tile combinations in multiTileDictionary: " + Utils.format(this.writerDictionary.size()));
            }
            try {
                this.writeWay(w);
            }
            catch (IOException e) {
                throw new SplitFailedException("failed to write way " + w.getId(), e);
            }
        }
    }

    @Override
    public void processRelation(Relation rel) {
        this.usedWriters.clear();
        Integer singleTileWriterIdx = this.dataStorer.getOneTileOnlyRels(rel.getId());
        if (singleTileWriterIdx != null) {
            if (singleTileWriterIdx == Short.MIN_VALUE) {
                return;
            }
            this.setUsedWriters(singleTileWriterIdx);
        } else {
            int multiTileWriterIdx;
            int n = multiTileWriterIdx = this.relWriterMap != null ? this.relWriterMap.getSeq(rel.getId()) : Short.MIN_VALUE;
            if (multiTileWriterIdx != Short.MIN_VALUE) {
                this.setUsedWriters(multiTileWriterIdx);
            } else {
                int oldclIndex = Short.MIN_VALUE;
                int oldwlIndex = Short.MIN_VALUE;
                for (Relation.Member mem : rel.getMembers()) {
                    int wlIdx;
                    long id = mem.getRef();
                    if ("node".equals(mem.getType())) {
                        int clIdx = this.coords.get(id);
                        if (clIdx == Short.MIN_VALUE) continue;
                        if (oldclIndex != clIdx) {
                            this.usedWriters.or(this.writerDictionary.getSet(clIdx));
                        }
                        oldclIndex = clIdx;
                        continue;
                    }
                    if (!"way".equals(mem.getType()) || (wlIdx = this.ways.get(id)) == Short.MIN_VALUE) continue;
                    if (oldwlIndex != wlIdx) {
                        this.usedWriters.or(this.writerDictionary.getSet(wlIdx));
                    }
                    oldwlIndex = wlIdx;
                }
            }
        }
        try {
            this.writeRelation(rel);
        }
        catch (IOException e) {
            throw new SplitFailedException("failed to write relation " + rel.getId(), e);
        }
    }

    @Override
    public boolean endMap() {
        this.coords.stats(0);
        this.ways.stats(0);
        Utils.printMem();
        System.out.println("Full Node tests:  " + Utils.format(this.countFullTest));
        System.out.println("Quick Node tests: " + Utils.format(this.countQuickTest));
        this.coords = null;
        this.ways = null;
        for (int i = 0; i < this.writerInputQueues.length; ++i) {
            try {
                this.writerInputQueues[i].stop();
                continue;
            }
            catch (InterruptedException e) {
                throw new SplitFailedException("Failed to add the stop element for worker thread " + i, e);
            }
        }
        try {
            if (this.maxThreads > 1) {
                this.toProcess.put(this.stopMsg);
            }
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        for (Thread workerThread : this.workerThreads) {
            try {
                workerThread.join();
            }
            catch (InterruptedException e) {
                throw new SplitFailedException("Failed to join for thread " + workerThread.getName(), e);
            }
        }
        for (int i = this.writerOffset; i <= this.lastWriter; ++i) {
            this.writers[i].finishWrite();
        }
        return true;
    }

    private void writeNode(Node currentNode) throws IOException {
        boolean isSpecialNode;
        int countWriters = 0;
        int lastUsedWriter = Short.MIN_VALUE;
        AreaGridResult writerCandidates = this.writerIndex.get(currentNode);
        int multiTileWriterIdx = this.nodeWriterMap != null ? this.nodeWriterMap.getSeq(currentNode.getId()) : Short.MIN_VALUE;
        boolean bl = isSpecialNode = multiTileWriterIdx != Short.MIN_VALUE;
        if (writerCandidates == null && !isSpecialNode) {
            return;
        }
        this.usedWriters.clear();
        if (writerCandidates != null) {
            for (int n : writerCandidates.set) {
                boolean found;
                if (n < this.writerOffset || n > this.lastWriter) continue;
                OSMWriter writer = this.writers[n];
                if (writerCandidates.testNeeded) {
                    found = writer.getExtendedBounds().contains(currentNode);
                    ++this.countFullTest;
                } else {
                    found = true;
                    ++this.countQuickTest;
                }
                if (!found) continue;
                this.usedWriters.set(n);
                ++countWriters;
                lastUsedWriter = n;
                if (this.maxThreads > 1) {
                    this.addToWorkingQueue(n, currentNode);
                    continue;
                }
                writer.write(currentNode);
            }
        }
        if (isSpecialNode) {
            AreaSet nodeWriters = this.writerDictionary.getSet(multiTileWriterIdx);
            for (int i : nodeWriters) {
                if (i < this.writerOffset || i > this.lastWriter || this.usedWriters.get(i)) continue;
                if (this.maxThreads > 1) {
                    this.addToWorkingQueue(i, currentNode);
                    continue;
                }
                this.writers[i].write(currentNode);
            }
        }
        if (countWriters > 0) {
            int writersID = countWriters > 1 ? this.writerDictionary.translate(this.usedWriters) : AreaDictionary.translate(lastUsedWriter);
            this.coords.put(currentNode.getId(), writersID);
            ++this.countCoords;
            if (this.countCoords % 100000000L == 0L) {
                System.out.println("coord MAP occupancy: " + Utils.format(this.countCoords) + ", number of area dictionary entries: " + this.writerDictionary.size());
            }
        }
    }

    private void writeWay(Way currentWay) throws IOException {
        if (!this.seenWay) {
            this.seenWay = true;
            System.out.println("Writing ways " + new Date());
        }
        this.writeElement(currentWay, this.usedWriters);
    }

    private void writeRelation(Relation currentRelation) throws IOException {
        if (!this.seenRel) {
            this.seenRel = true;
            System.out.println("Writing relations " + new Date());
        }
        this.writeElement(currentRelation, this.usedWriters);
    }

    private void writeElement(Element el, AreaSet writersToUse) throws IOException {
        if (!writersToUse.isEmpty()) {
            for (int n : writersToUse) {
                if (n < this.writerOffset || n > this.lastWriter) continue;
                if (this.maxThreads > 1) {
                    this.addToWorkingQueue(n, el);
                    continue;
                }
                this.writers[n].write(el);
            }
        }
    }

    private void addToWorkingQueue(int writerNumber, Element element) {
        try {
            this.writerInputQueues[writerNumber - this.writerOffset].put(element);
        }
        catch (InterruptedException e) {
            throw new SplitFailedException("Failed to add to working queue", e);
        }
    }

    private class OSMWriterWorker
    implements Runnable {
        private OSMWriterWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean finished = false;
            while (!finished) {
                InputQueueInfo workPackage = null;
                try {
                    workPackage = SplitProcessor.this.toProcess.take();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    continue;
                }
                if (workPackage == SplitProcessor.this.stopMsg) {
                    try {
                        SplitProcessor.this.toProcess.put(SplitProcessor.this.stopMsg);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    finished = true;
                    continue;
                }
                InputQueueInfo inputQueueInfo = workPackage;
                synchronized (inputQueueInfo) {
                    while (!workPackage.inputQueue.isEmpty()) {
                        ArrayList elements = null;
                        try {
                            elements = (ArrayList)workPackage.inputQueue.poll();
                            for (Element element : elements) {
                                workPackage.writer.write(element);
                            }
                        }
                        catch (IOException e) {
                            throw new SplitFailedException("Thread " + Thread.currentThread().getName() + " failed to write element ", e);
                        }
                    }
                }
            }
            System.out.println("Thread " + Thread.currentThread().getName() + " has finished");
        }
    }

    private class InputQueueInfo {
        protected final OSMWriter writer;
        private ArrayList<Element> staging;
        protected final BlockingQueue<ArrayList<Element>> inputQueue = new ArrayBlockingQueue<ArrayList<Element>>(3);

        public InputQueueInfo(OSMWriter writer) {
            this.writer = writer;
            this.staging = new ArrayList(300);
        }

        void put(Element e) throws InterruptedException {
            this.staging.add(e);
            if (this.staging.size() >= 300) {
                this.flush();
            }
        }

        void flush() throws InterruptedException {
            this.inputQueue.put(this.staging);
            this.staging = new ArrayList(300);
            SplitProcessor.this.toProcess.put(this);
        }

        void stop() throws InterruptedException {
            this.flush();
        }
    }
}

