/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.splitter;

public class JVMHealthMonitor {
    private final Thread statusThread;
    private static long startTime;

    public JVMHealthMonitor(final long statusFrequency) {
        startTime = System.currentTimeMillis();
        this.statusThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int iter = 0;
                while (true) {
                    if (++iter % 10 == 0) {
                        System.out.println("***** Full GC *****");
                        System.gc();
                    }
                    long maxMem = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
                    long totalMem = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
                    long freeMem = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
                    long usedMem = totalMem - freeMem;
                    System.out.println("Elapsed time: " + JVMHealthMonitor.getElapsedTime() + "   Memory: Current " + totalMem + "MB (" + usedMem + "MB used, " + freeMem + "MB free) Max " + maxMem + "MB");
                    try {
                        Thread.sleep(statusFrequency * 1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        System.out.println("JVMHealthMonitor sleep was interrupted. Ignoring.");
                        continue;
                    }
                    break;
                }
            }
        });
        this.statusThread.setDaemon(true);
        this.statusThread.setName("JVMHealthMonitor");
    }

    public void start() {
        if (!this.statusThread.isAlive()) {
            this.statusThread.start();
        }
    }

    protected static String getElapsedTime() {
        long elapsed = (System.currentTimeMillis() - startTime) / 1000L;
        long seconds = elapsed % 60L;
        long minutes = elapsed / 60L % 60L;
        long hours = elapsed / 3600L % 60L;
        StringBuilder buf = new StringBuilder(20);
        if (hours > 0L) {
            buf.append(hours).append("h ");
        }
        if (hours > 0L || minutes > 0L) {
            buf.append(minutes).append("m ");
        }
        buf.append(seconds).append('s');
        return buf.toString();
    }
}

