/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.hgt;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.parabola.log.Logger;

public class HGTList {
    private static final Logger log = Logger.getLogger(HGTList.class);
    private static final HGTList instance = new HGTList();
    private BitSet knownHgt;

    private HGTList() {
        try {
            this.knownHgt = this.loadConfig();
        }
        catch (IOException e) {
            Logger.defaultLogger.error((Object)"Error reading hgt config", e);
        }
    }

    public static HGTList get() {
        return instance;
    }

    public BitSet getKnownHGT() {
        return this.knownHgt;
    }

    private BitSet loadConfig() throws IOException {
        int bytesRemaining;
        int bytesRead;
        try {
            String name = "hgt/known-hgt.txt";
            BitSet bs = HGTList.compileHGTList(name);
            if (bs != null) {
                System.out.println("HGTList uses " + name);
                return bs;
            }
        }
        catch (Exception name) {
            // empty catch block
        }
        InputStream inStream = this.getClass().getResourceAsStream("/known-hgt.bin");
        byte[] buf = new byte[8100];
        int totalBytesRead = 0;
        while (totalBytesRead < buf.length && (bytesRead = inStream.read(buf, totalBytesRead, bytesRemaining = buf.length - totalBytesRead)) >= 0) {
            if (bytesRead <= 0) continue;
            totalBytesRead += bytesRead;
        }
        inStream.close();
        return BitSet.valueOf(buf);
    }

    private static BitSet compileHGTList(String filename) throws IOException {
        Pattern hgtPattern = Pattern.compile("([sSnN])(\\d{2})([eEwW])(\\d{3}).*");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));){
            String strLine;
            BitSet bs = new BitSet(64800);
            while ((strLine = br.readLine()) != null) {
                if ((strLine = strLine.trim()).isEmpty() || strLine.startsWith("#")) continue;
                Matcher m = hgtPattern.matcher(strLine);
                if (!m.matches()) {
                    log.error("don't know how to handle", strLine);
                    continue;
                }
                try {
                    String sn = m.group(1).toUpperCase();
                    int lat = Integer.parseInt(m.group(2));
                    String ew = m.group(3).toUpperCase();
                    int lon = Integer.parseInt(m.group(4));
                    if ("S".equals(sn)) {
                        lat = -lat;
                    }
                    if ("W".equals(ew)) {
                        lon = -lon;
                    }
                    bs.set(HGTList.getBitSetPos(lat, lon));
                }
                catch (NumberFormatException e) {
                    Logger.defaultLogger.error((Object)"Error reading latitude/longitude", e);
                }
            }
            BitSet bitSet = bs;
            return bitSet;
        }
    }

    private static int getBitSetPos(int lat, int lon) {
        assert (lat >= -90 && lat < 90 && lon >= -180 && lon < 180);
        return (90 + lat) * 360 + lon + 180;
    }

    public synchronized boolean shouldExist(int lat, int lon) {
        if (this.knownHgt != null) {
            return this.knownHgt.get(HGTList.getBitSetPos(lat, lon));
        }
        return false;
    }

    public static void main(String[] args) throws IOException {
        if (args.length >= 2 && "compile".equals(args[0])) {
            BitSet bs = HGTList.compileHGTList(args[1]);
            String outName = args.length > 2 ? args[2] : "known-hgt.bin";
            try (RandomAccessFile raf = new RandomAccessFile(outName, "rw");){
                raf.write(bs.toByteArray());
            }
        } else {
            System.out.println("usage: HGTList compile hgt-list [outfile name]");
        }
    }
}

