/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.housenumber;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberElem;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberGenerator;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberGroup;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberRoad;
import uk.me.parabola.mkgmap.reader.osm.Way;

public class HousenumberMatch
extends HousenumberElem {
    private MapRoad road;
    private HousenumberRoad housenumberRoad;
    private double distance = Double.POSITIVE_INFINITY;
    private int segment = -1;
    private boolean left;
    private double segmentFrac;
    private boolean ignored;
    private boolean isDuplicate;
    private boolean interpolated;
    private int moved;
    private double searchDist = Double.NaN;
    private boolean isFarDuplicate;
    private HousenumberGroup group;
    private List<MapRoad> alternativeRoads;
    private int intervalInfoRefs;

    public HousenumberMatch(HousenumberElem he) {
        super(he);
    }

    @Override
    public MapRoad getRoad() {
        return this.road;
    }

    public void setRoad(MapRoad road) {
        this.road = road;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public int getSegment() {
        return this.segment;
    }

    public void setSegment(int segment) {
        this.segment = segment;
    }

    public boolean isLeft() {
        return this.left;
    }

    public void setLeft(boolean left) {
        this.left = left;
    }

    public double getSegmentFrac() {
        return this.segmentFrac;
    }

    public void setSegmentFrac(double segmentFrac) {
        this.segmentFrac = segmentFrac;
    }

    public boolean hasAlternativeRoad() {
        return this.alternativeRoads != null && !this.alternativeRoads.isEmpty();
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    public void setDuplicate(boolean isDuplicate) {
        this.isDuplicate = isDuplicate;
    }

    public boolean isInterpolated() {
        return this.interpolated;
    }

    public void setInterpolated(boolean interpolated) {
        this.interpolated = interpolated;
    }

    public int getMoved() {
        return this.moved;
    }

    public void incMoved() {
        ++this.moved;
    }

    public double getSearchDist() {
        return this.searchDist;
    }

    public void setSearchDist(double searchDist) {
        this.searchDist = searchDist;
    }

    @Override
    public String toString() {
        String s1 = String.valueOf(this.getHousenumber());
        if (this.getSign().length() > 2 + s1.length()) {
            return s1 + "(" + this.segment + ")";
        }
        return this.getSign() + "(" + this.segment + ")";
    }

    public void setFarDuplicate(boolean b) {
        this.isFarDuplicate = b;
    }

    public boolean isFarDuplicate() {
        return this.isFarDuplicate;
    }

    public Coord getClosestPointOnRoad() {
        if (this.segmentFrac <= 0.0) {
            return this.getRoad().getPoints().get(this.segment);
        }
        if (this.segmentFrac >= 1.0) {
            return this.getRoad().getPoints().get(this.segment + 1);
        }
        Coord c1 = this.getRoad().getPoints().get(this.segment);
        Coord c2 = this.getRoad().getPoints().get(this.segment + 1);
        return c1.makeBetweenPoint(c2, this.segmentFrac);
    }

    public double getDistOnRoad(HousenumberMatch other) {
        double segLen;
        int s1;
        if (this.getRoad() != other.getRoad()) assert (false) : "cannot compute distance on road for different roads";
        List<Coord> points = this.getRoad().getPoints();
        HousenumberMatch house1 = this;
        HousenumberMatch house2 = other;
        if (house1.segment > house2.segment || house1.segment == house2.segment && house1.segmentFrac > house2.segmentFrac) {
            house1 = other;
            house2 = this;
        }
        int s2 = house2.segment;
        double distOnRoad = 0.0;
        for (s1 = house1.segment; s1 < s2; ++s1) {
            segLen = points.get(s1).distance(points.get(s1 + 1));
            if (s1 == house1.getSegment() && house1.getSegmentFrac() > 0.0) {
                distOnRoad += Math.max(0.0, 1.0 - house1.getSegmentFrac()) * segLen;
                continue;
            }
            distOnRoad += segLen;
        }
        segLen = points.get(s1).distance(points.get(s1 + 1));
        if (house2.getSegmentFrac() > 0.0) {
            distOnRoad += Math.min(1.0, house2.getSegmentFrac()) * segLen;
        }
        if (house1.getSegmentFrac() > 0.0 && s1 == house1.segment) {
            distOnRoad -= Math.min(1.0, house1.getSegmentFrac()) * segLen;
        }
        return distOnRoad;
    }

    public HousenumberRoad getHousenumberRoad() {
        return this.housenumberRoad;
    }

    public void setHousenumberRoad(HousenumberRoad housenumberRoad) {
        this.housenumberRoad = housenumberRoad;
    }

    public void setGroup(HousenumberGroup housenumberBlock) {
        this.group = housenumberBlock;
    }

    public HousenumberGroup getGroup() {
        return this.group;
    }

    public void addAlternativeRoad(MapRoad road2) {
        if (this.alternativeRoads == null) {
            this.alternativeRoads = new ArrayList<MapRoad>();
        }
        this.alternativeRoads.add(road2);
    }

    public List<MapRoad> getAlternativeRoads() {
        if (this.alternativeRoads == null) {
            return Collections.emptyList();
        }
        return this.alternativeRoads;
    }

    public void forgetAlternativeRoads() {
        this.alternativeRoads = null;
    }

    public int getIntervalInfoRefs() {
        return this.intervalInfoRefs;
    }

    public void incIntervalInfoRefs() {
        ++this.intervalInfoRefs;
    }

    public void decIntervalInfoRefs() {
        if (this.intervalInfoRefs > 0) {
            --this.intervalInfoRefs;
        }
    }

    public boolean isDirectlyConnected(HousenumberMatch other) {
        if (this.getElement() instanceof Way && other.getElement() instanceof Way) {
            Coord co;
            List<Coord> s1 = ((Way)this.getElement()).getPoints();
            List<Coord> s2 = ((Way)other.getElement()).getPoints();
            int i = 0;
            while (i + 1 < s1.size()) {
                co = s1.get(i);
                co.setPartOfShape2(false);
                ++i;
            }
            i = 0;
            while (i + 1 < s2.size()) {
                co = s2.get(i);
                co.setPartOfShape2(true);
                ++i;
            }
            i = 0;
            while (i + 1 < s1.size()) {
                co = s1.get(i);
                if (co.isPartOfShape2()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void calcRoadSide() {
        if (this.getRoad() == null) {
            return;
        }
        Coord c1 = this.getRoad().getPoints().get(this.getSegment());
        Coord c2 = this.getRoad().getPoints().get(this.getSegment() + 1);
        this.setLeft(HousenumberGenerator.isLeft(c1, c2, this.getLocation()));
    }

    public boolean isEqualAddress(HousenumberElem other) {
        if (this.getRoad() != other.getRoad()) {
            return false;
        }
        if (!this.getSign().equals(other.getSign())) {
            return false;
        }
        if (this.getPlace() != other.getPlace()) {
            if (this.getPlace() == null) {
                return false;
            }
            if (!this.getPlace().equals(other.getPlace())) {
                return false;
            }
        }
        if (this.getZipCode() != null && other.getZipCode() != null && !this.getZipCode().equals(other.getZipCode())) {
            return false;
        }
        return this.getCityInfo() == null || other.getCityInfo() == null || this.getCityInfo().equals(other.getCityInfo());
    }
}

