/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import java.io.IOException;
import uk.me.parabola.imgfmt.ReadFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.CommonHeader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;
import uk.me.parabola.imgfmt.app.trergn.MapValues;
import uk.me.parabola.log.Logger;
import uk.me.parabola.util.EnhancedProperties;

public class TREHeader
extends CommonHeader {
    private static final Logger log = Logger.getLogger(TREHeader.class);
    public static final int TRE_120 = 120;
    public static final int TRE_184 = 184;
    private static final int TRE_188 = 188;
    private static final int DEFAULT_HEADER_LEN = 188;
    private static final int DEFAULT_DISPLAY_PRIORITY = 25;
    static final int MAP_LEVEL_REC_SIZE = 4;
    private static final char POLYLINE_REC_LEN = '\u0002';
    private static final char POLYGON_REC_LEN = '\u0002';
    private static final char POINT_REC_LEN = '\u0003';
    private static final char COPYRIGHT_REC_SIZE = '\u0003';
    private static final char EXT_TYPE_OFFSETS_REC_LEN = '\r';
    private static final char EXT_TYPE_OVERVIEWS_REC_LEN = '\u0004';
    static final int SUBDIV_REC_SIZE = 14;
    static final int SUBDIV_REC_SIZE2 = 16;
    public static final int POI_FLAG_DETAIL = 1;
    public static final int POI_FLAG_TRANSPARENT = 2;
    public static final int POI_FLAG_STREET_BEFORE_HOUSENUMBER = 4;
    public static final int POI_FLAG_POSTALCODE_BEFORE_CITY = 8;
    public static final int POI_FLAG_DRIVE_ON_LEFT = 32;
    private Area area = new Area(0, 0, 0, 0);
    private int mapInfoSize;
    private int mapLevelPos;
    private int mapLevelsSize;
    private int subdivPos;
    private int subdivSize;
    private int poiDisplayFlags;
    private int displayPriority = 25;
    private final Section copyright = new Section(3);
    private final Section polyline = new Section(2);
    private final Section polygon = new Section(2);
    private final Section points = new Section(3);
    private final Section extTypeOffsets = new Section(this.points, 13);
    private final Section extTypeOverviews = new Section(this.extTypeOffsets, 4);
    private int numExtTypeAreaTypes;
    private int numExtTypeLineTypes;
    private int numExtTypePointTypes;
    private int mapId;
    private boolean custom;

    public TREHeader() {
        super(188, "GARMIN TRE");
    }

    @Override
    protected void readFileHeader(ImgFileReader reader) throws ReadFailedException {
        if (reader.position() - (long)reader.getGMPOffset() != 21L) {
            throw new ReadFailedException("Reader position not at expected header length", new IOException());
        }
        int maxLat = reader.get3s();
        int maxLon = reader.get3s();
        int minLat = reader.get3s();
        int minLon = reader.get3s();
        if (maxLon < minLon && maxLon == -8388608) {
            maxLon = 0x800000;
        }
        this.setBounds(new Area(minLat, minLon, maxLat, maxLon));
        log.info("read area is", this.getBounds());
        this.mapLevelPos = reader.get4();
        this.mapLevelsSize = reader.get4();
        this.subdivPos = reader.get4();
        this.subdivSize = reader.get4();
        this.copyright.readSectionInfo(reader, true, true);
        this.poiDisplayFlags = reader.get1u();
        this.displayPriority = reader.get3u();
        reader.get4();
        reader.get2u();
        reader.get();
        this.polyline.readSectionInfo(reader, true, true);
        this.polygon.readSectionInfo(reader, true, true);
        this.points.readSectionInfo(reader, true, true);
        int mapInfoOff = this.mapLevelPos;
        if (this.subdivPos < mapInfoOff) {
            mapInfoOff = this.subdivPos;
        }
        if (this.copyright.getPosition() < mapInfoOff) {
            mapInfoOff = this.copyright.getPosition();
        }
        this.mapInfoSize = mapInfoOff - this.getHeaderLength();
        if (this.getHeaderLength() > 116) {
            assert (reader.position() == (long)(reader.getGMPOffset() + 116));
            this.mapId = reader.get4();
        }
        if (this.getHeaderLength() > 120) {
            reader.get4();
            assert (reader.position() == (long)(reader.getGMPOffset() + 124));
            this.extTypeOffsets.readSectionInfo(reader, true, true);
        }
    }

    @Override
    protected void writeFileHeader(ImgFileWriter writer) {
        writer.put3s(this.area.getMaxLat());
        Utils.put3sLongitude(writer, this.area.getMaxLong());
        writer.put3s(this.area.getMinLat());
        writer.put3s(this.area.getMinLong());
        writer.put4(this.getMapLevelsPos());
        writer.put4(this.getMapLevelsSize());
        writer.put4(this.getSubdivPos());
        writer.put4(this.getSubdivSize());
        this.copyright.writeSectionInfo(writer);
        writer.put4(0);
        writer.put1u(this.getPoiDisplayFlags());
        writer.put3u(this.displayPriority);
        if (this.custom) {
            writer.put4(1508353);
        } else {
            writer.put4(0x110301);
        }
        writer.put2u(1);
        writer.put1u(0);
        this.polyline.writeSectionInfo(writer);
        writer.put4(0);
        this.polygon.writeSectionInfo(writer);
        writer.put4(0);
        this.points.writeSectionInfo(writer);
        writer.put4(0);
        if (this.getHeaderLength() > 116) {
            writer.put4(this.getMapId());
        }
        if (this.getHeaderLength() > 120) {
            writer.put4(0);
            if (this.extTypeOffsets.getSize() == 0) {
                this.extTypeOffsets.setItemSize(0);
            }
            this.extTypeOffsets.writeSectionInfo(writer, true);
            writer.put4(1543);
            this.extTypeOverviews.writeSectionInfo(writer);
            writer.put2u(this.numExtTypeLineTypes);
            writer.put2u(this.numExtTypeAreaTypes);
            writer.put2u(this.numExtTypePointTypes);
        }
        if (this.getHeaderLength() > 154) {
            MapValues mv = new MapValues(this.mapId, this.getHeaderLength());
            mv.calculate();
            writer.put4(mv.value(0));
            writer.put4(mv.value(1));
            writer.put4(mv.value(2));
            writer.put4(mv.value(3));
            writer.put4(0);
            writer.put4(0);
            writer.put4(0);
            writer.put2u(0);
            writer.put4(0);
        }
        writer.position(this.getHeaderLength());
    }

    public void config(EnhancedProperties props) {
        String key = "draw-priority";
        if (props.containsKey(key)) {
            this.setDisplayPriority(props.getProperty(key, 25));
        }
        if (props.containsKey("transparent")) {
            this.poiDisplayFlags |= 2;
        }
        this.custom = props.containsKey("custom");
    }

    public void setBounds(Area area) {
        this.area = area;
    }

    public Area getBounds() {
        return this.area;
    }

    public void setMapId(int id) {
        this.mapId = id;
    }

    public void setDriveOnLeft(boolean dol) {
        if (dol) {
            this.poiDisplayFlags |= 0x20;
        }
    }

    public void addPoiDisplayFlags(int poiDisplayFlags) {
        this.poiDisplayFlags |= poiDisplayFlags;
    }

    public int getMapInfoSize() {
        return this.mapInfoSize;
    }

    public void setMapInfoSize(int mapInfoSize) {
        this.mapInfoSize = mapInfoSize;
    }

    public int getMapLevelsPos() {
        return this.mapLevelPos;
    }

    public void setMapLevelPos(int mapLevelPos) {
        this.mapLevelPos = mapLevelPos;
    }

    public int getMapLevelsSize() {
        return this.mapLevelsSize;
    }

    public void setMapLevelsSize(int mapLevelsSize) {
        this.mapLevelsSize = mapLevelsSize;
    }

    public int getSubdivPos() {
        return this.subdivPos;
    }

    public void setSubdivPos(int subdivPos) {
        this.subdivPos = subdivPos;
    }

    public int getSubdivSize() {
        return this.subdivSize;
    }

    public void setSubdivSize(int subdivSize) {
        this.subdivSize = subdivSize;
    }

    public void setCopyrightPos(int copyrightPos) {
        this.copyright.setPosition(copyrightPos);
    }

    public void incCopyrightSize() {
        this.copyright.inc();
    }

    protected int getPoiDisplayFlags() {
        return this.poiDisplayFlags;
    }

    public void setPolylinePos(int polylinePos) {
        this.polyline.setPosition(polylinePos);
    }

    public void incPolylineSize() {
        this.polyline.inc();
    }

    public void setPolygonPos(int polygonPos) {
        this.polygon.setPosition(polygonPos);
    }

    public void incPolygonSize() {
        this.polygon.inc();
    }

    public void setPointPos(int pointPos) {
        this.points.setPosition(pointPos);
    }

    public void incPointSize() {
        this.points.inc();
    }

    public void setExtTypeOffsetsPos(int pos) {
        this.extTypeOffsets.setPosition(pos);
    }

    public void incExtTypeOffsetsSize() {
        this.extTypeOffsets.inc();
    }

    public void setExtTypeOverviewsPos(int pos) {
        this.extTypeOverviews.setPosition(pos);
    }

    public void incExtTypeOverviewsSize() {
        this.extTypeOverviews.inc();
    }

    public void incNumExtTypeAreaTypes() {
        ++this.numExtTypeAreaTypes;
    }

    public void incNumExtTypeLineTypes() {
        ++this.numExtTypeLineTypes;
    }

    public void incNumExtTypePointTypes() {
        ++this.numExtTypePointTypes;
    }

    public int getMapId() {
        return this.mapId;
    }

    protected void setDisplayPriority(int displayPriority) {
        this.displayPriority = displayPriority;
    }

    public int getDisplayPriority() {
        return this.displayPriority;
    }

    public int getExtTypeOffsetsPos() {
        return this.extTypeOffsets.getPosition();
    }

    public int getExtTypeOffsetsSize() {
        return this.extTypeOffsets.getSize();
    }

    public int getExtTypeSectionSize() {
        return this.extTypeOffsets.getItemSize();
    }

    public int getTre7Magic() {
        return this.extTypeOffsets.getExtraValue();
    }

    public Section getCopyrightSection() {
        return this.copyright;
    }
}

