/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr1MapIndex;
import uk.me.parabola.imgfmt.app.mdr.Mdr1Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;

public class Mdr1
extends MdrSection
implements HasHeaderFlags {
    private final List<Mdr1Record> maps = new ArrayList<Mdr1Record>();

    public Mdr1(MdrConfig config) {
        this.setConfig(config);
    }

    public void addMap(int mapNumber, int index) {
        assert (index > 0);
        Mdr1Record rec = new Mdr1Record(mapNumber);
        rec.setMapIndex(index);
        this.maps.add(rec);
        if (!this.isForDevice()) {
            Mdr1MapIndex mapIndex = new Mdr1MapIndex();
            rec.setMdrMapIndex(mapIndex);
        }
    }

    public void writeSubSections(ImgFileWriter writer) {
        if (this.isForDevice()) {
            return;
        }
        for (Mdr1Record rec : this.maps) {
            rec.setIndexOffset(writer.position());
            Mdr1MapIndex mapIndex = rec.getMdrMapIndex();
            mapIndex.writeSubSection(writer);
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        boolean revIndex = (this.getExtraValue() & 1) != 0;
        for (Mdr1Record rec : this.maps) {
            writer.put4(rec.getMapNumber());
            if (!revIndex) continue;
            writer.put4(rec.getIndexOffset());
        }
    }

    @Override
    public int getItemSize() {
        return this.isForDevice() ? 4 : 8;
    }

    public void setStartPosition(int sectionNumber) {
    }

    public void setEndPosition(int sectionNumber) {
        if (this.isForDevice()) {
            return;
        }
        for (Mdr1Record mi : this.maps) {
            mi.getMdrMapIndex().endSection(sectionNumber);
        }
    }

    public void setPointerSize(int sectionSize, int recordSize) {
        for (Mdr1Record mi : this.maps) {
            Mdr1MapIndex mapIndex = mi.getMdrMapIndex();
            mapIndex.setPointerSize(sectionSize, recordSize);
        }
    }

    public void addPointer(int mapNumber, int recordNumber) {
        Mdr1MapIndex mi = this.maps.get(mapNumber - 1).getMdrMapIndex();
        mi.addPointer(recordNumber);
    }

    @Override
    protected int numberOfItems() {
        return this.maps.size();
    }

    @Override
    public int getExtraValue() {
        int magic = 0;
        if (!this.isForDevice()) {
            magic |= 1;
        }
        return magic;
    }
}

