/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.GeneralRelation;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmHandler;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Way;

public class OsmXmlHandler
extends OsmHandler {
    private static final Logger log = Logger.getLogger(OsmXmlHandler.class);
    private int mode;
    private static final int MODE_NODE = 1;
    private static final int MODE_WAY = 2;
    private static final int MODE_BOUND = 3;
    private static final int MODE_RELATION = 4;
    private static final int MODE_BOUNDS = 5;
    private Node currentNode;
    private Way currentWay;
    private Relation currentRelation;
    private long currentElementId;

    @Override
    public boolean isFileSupported(String name) {
        return true;
    }

    @Override
    public void parse(InputStream is) throws FormatException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setXIncludeAware(true);
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            try {
                SaxHandler saxHandler = new SaxHandler();
                parser.parse(is, (DefaultHandler)saxHandler);
            }
            catch (IOException e) {
                throw new FormatException("Error reading file", e);
            }
        }
        catch (SAXException e) {
            throw new FormatException("Error parsing file", e);
        }
        catch (ParserConfigurationException e) {
            throw new FormatException("Internal error configuring xml parser", e);
        }
    }

    public class SaxHandler
    extends DefaultHandler {
        private final Map<String, Long> fakeIdMap = new HashMap<String, Long>();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (OsmXmlHandler.this.mode == 0) {
                if ("node".equals(qName)) {
                    OsmXmlHandler.this.mode = 1;
                    this.startXmlNode(attributes.getValue("id"), attributes.getValue("lat"), attributes.getValue("lon"));
                } else if ("way".equals(qName)) {
                    OsmXmlHandler.this.mode = 2;
                    this.startXmlWay(attributes.getValue("id"));
                } else if ("relation".equals(qName)) {
                    OsmXmlHandler.this.mode = 4;
                    OsmXmlHandler.this.currentRelation = new GeneralRelation(this.idVal(attributes.getValue("id")));
                } else if ("bound".equals(qName)) {
                    OsmXmlHandler.this.mode = 3;
                    if (!OsmXmlHandler.this.isIgnoreBounds()) {
                        String box = attributes.getValue("box");
                        this.setupBBoxFromBound(box);
                    }
                } else if ("bounds".equals(qName)) {
                    OsmXmlHandler.this.mode = 5;
                    if (!OsmXmlHandler.this.isIgnoreBounds()) {
                        this.setupBBoxFromBounds(attributes);
                    }
                }
            } else if (OsmXmlHandler.this.mode == 1) {
                this.startInNode(qName, attributes);
            } else if (OsmXmlHandler.this.mode == 2) {
                this.startInWay(qName, attributes);
            } else if (OsmXmlHandler.this.mode == 4) {
                this.startInRelation(qName, attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (OsmXmlHandler.this.mode == 1) {
                if ("node".equals(qName)) {
                    OsmXmlHandler.this.mode = 0;
                    if (OsmXmlHandler.this.currentNode != null) {
                        OsmXmlHandler.this.saver.addNode(OsmXmlHandler.this.currentNode);
                        OsmXmlHandler.this.hooks.onAddNode(OsmXmlHandler.this.currentNode);
                    }
                    OsmXmlHandler.this.currentElementId = 0L;
                    OsmXmlHandler.this.currentNode = null;
                }
            } else if (OsmXmlHandler.this.mode == 2) {
                if ("way".equals(qName)) {
                    OsmXmlHandler.this.mode = 0;
                    OsmXmlHandler.this.endWay(OsmXmlHandler.this.currentWay);
                    OsmXmlHandler.this.currentWay = null;
                }
            } else if (OsmXmlHandler.this.mode == 3) {
                if ("bound".equals(qName)) {
                    OsmXmlHandler.this.mode = 0;
                }
            } else if (OsmXmlHandler.this.mode == 5) {
                if ("bounds".equals(qName)) {
                    OsmXmlHandler.this.mode = 0;
                }
            } else if (OsmXmlHandler.this.mode == 4 && "relation".equals(qName)) {
                OsmXmlHandler.this.mode = 0;
                OsmXmlHandler.this.saver.addRelation(OsmXmlHandler.this.currentRelation);
            }
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            Logger.defaultLogger.error((Object)("Error at line " + e.getLineNumber() + ", col " + e.getColumnNumber()));
            super.fatalError(e);
        }

        private void startInNode(String qName, Attributes attributes) {
            if ("tag".equals(qName)) {
                String key = attributes.getValue("k");
                String val = attributes.getValue("v");
                if ((key = OsmXmlHandler.this.keepTag(key, val)) != null) {
                    if (OsmXmlHandler.this.currentNode == null) {
                        Coord co = OsmXmlHandler.this.saver.getCoord(OsmXmlHandler.this.currentElementId);
                        OsmXmlHandler.this.currentNode = new Node(OsmXmlHandler.this.currentElementId, co);
                    }
                    OsmXmlHandler.this.currentNode.addTagFromRawOSM(key, val);
                }
            }
        }

        private void startInWay(String qName, Attributes attributes) {
            if ("nd".equals(qName)) {
                long id = this.idVal(attributes.getValue("ref"));
                OsmXmlHandler.this.addCoordToWay(OsmXmlHandler.this.currentWay, id);
            } else if ("tag".equals(qName)) {
                String key = attributes.getValue("k");
                String val = attributes.getValue("v");
                if ((key = OsmXmlHandler.this.keepTag(key, val)) != null) {
                    OsmXmlHandler.this.currentWay.addTagFromRawOSM(key, val);
                }
            }
        }

        private void startInRelation(String qName, Attributes attributes) {
            if ("member".equals(qName)) {
                Element el;
                long id = this.idVal(attributes.getValue("ref"));
                String type = attributes.getValue("type");
                if ("way".equals(type)) {
                    el = OsmXmlHandler.this.saver.getWay(id);
                } else if ("node".equals(type)) {
                    el = OsmXmlHandler.this.saver.getOrCreateNode(id);
                } else if ("relation".equals(type)) {
                    el = OsmXmlHandler.this.saver.getRelation(id);
                    if (el == null) {
                        OsmXmlHandler.this.saver.deferRelation(id, OsmXmlHandler.this.currentRelation, attributes.getValue("role"));
                    }
                } else {
                    el = null;
                }
                if (el != null) {
                    OsmXmlHandler.this.currentRelation.addElement(attributes.getValue("role"), el);
                }
            } else if ("tag".equals(qName)) {
                String key = attributes.getValue("k");
                String val = attributes.getValue("v");
                if ((key = "type".equals(key) ? "type" : OsmXmlHandler.this.keepTag(key, val)) != null) {
                    OsmXmlHandler.this.currentRelation.addTagFromRawOSM(key, val);
                }
            }
        }

        private void setupBBoxFromBounds(Attributes xmlattr) {
            try {
                OsmXmlHandler.this.setBBox(Double.parseDouble(xmlattr.getValue("minlat")), Double.parseDouble(xmlattr.getValue("minlon")), Double.parseDouble(xmlattr.getValue("maxlat")), Double.parseDouble(xmlattr.getValue("maxlon")));
            }
            catch (NumberFormatException e) {
                log.warn((Object)"NumberformatException: Cannot read bbox");
            }
        }

        private void setupBBoxFromBound(String box) {
            String[] f = box.split(",");
            try {
                OsmXmlHandler.this.setBBox(Double.parseDouble(f[0]), Double.parseDouble(f[1]), Double.parseDouble(f[2]), Double.parseDouble(f[3]));
            }
            catch (NumberFormatException e) {
                log.warn((Object)"NumberformatException: Cannot read bbox");
            }
        }

        private void startXmlNode(String sid, String slat, String slon) {
            if (sid == null || slat == null || slon == null) {
                return;
            }
            try {
                long id = this.idVal(sid);
                Coord co = new Coord(Double.parseDouble(slat), Double.parseDouble(slon));
                OsmXmlHandler.this.saver.addPoint(id, co);
                OsmXmlHandler.this.currentElementId = id;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private void startXmlWay(String sid) {
            try {
                long id = this.idVal(sid);
                OsmXmlHandler.this.currentWay = OsmXmlHandler.this.startWay(id);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private long idVal(String id) {
            try {
                return Long.parseLong(id);
            }
            catch (NumberFormatException e) {
                return this.fakeIdMap.putIfAbsent(id, FakeIdGenerator.makeFakeId());
            }
        }
    }
}

