/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.NameFinder;
import uk.me.parabola.mkgmap.osmstyle.housenumber.ExtNumbers;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooks;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.RestrictionRelation;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.MultiHashMap;

public class LinkDestinationHook
implements OsmReadingHooks {
    private static final Logger log = Logger.getLogger(LinkDestinationHook.class);
    private ElementSaver saver;
    private IdentityHashMap<Coord, Set<Way>> adjacentWays = new IdentityHashMap();
    private LinkedHashSet<Way> destinationLinkWays = new LinkedHashSet();
    private static final Set<String> highwayTypes = new LinkedHashSet<String>(Arrays.asList("motorway", "trunk", "primary", "secondary", "tertiary", "motorway_link", "trunk_link", "primary_link", "secondary_link", "tertiary_link"));
    private static final Set<String> linkTypes = new LinkedHashSet<String>(Arrays.asList("motorway_link", "trunk_link", "primary_link", "secondary_link", "tertiary_link"));
    private MultiHashMap<Long, RestrictionRelation> restrictions = new MultiHashMap();
    private NameFinder nameFinder;
    private IdentityHashMap<Coord, Set<Way>> wayNodes = new IdentityHashMap();
    private boolean processDestinations;
    private boolean processExits;
    private static final short TK_HIGHWAY = TagDict.getInstance().xlate("highway");
    private static final short TK_ONEWAY = TagDict.getInstance().xlate("oneway");
    private static final short TK_EXIT_TO = TagDict.getInstance().xlate("exit_to");
    private static final short TKM_DEST_HINT_WORK = TagDict.getInstance().xlate("mkgmap:dest_hint_work");

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props, Style style) {
        this.saver = saver;
        this.nameFinder = new NameFinder(props);
        this.processDestinations = props.containsKey("process-destination");
        this.processExits = props.containsKey("process-exits");
        return this.processDestinations || this.processExits;
    }

    private void retrieveWaysAndRelations() {
        for (Way w : this.saver.getWays().values()) {
            String highwayTag;
            if (w.getPoints().size() < 2 || (highwayTag = w.getTag(TK_HIGHWAY)) == null || !highwayTypes.contains(highwayTag)) continue;
            this.processHighWay(w, highwayTag);
        }
        for (Relation rel : this.saver.getRelations().values()) {
            if (!(rel instanceof RestrictionRelation)) continue;
            RestrictionRelation rrel = (RestrictionRelation)rel;
            for (Long wayId : rrel.getWayIds()) {
                this.restrictions.add(wayId, rrel);
            }
        }
    }

    private void processHighWay(Way w, String highwayTag) {
        List<Coord> points;
        String directionSuffix = null;
        if (LinkDestinationHook.isOnewayInDirection(w)) {
            points = w.getPoints().subList(0, w.getPoints().size() - 1);
            directionSuffix = "forward";
        } else if (LinkDestinationHook.isOnewayOppositeDirection(w)) {
            points = w.getPoints().subList(1, w.getPoints().size());
            directionSuffix = "backward";
        } else {
            points = w.getPoints();
        }
        for (Coord c : points) {
            this.adjacentWays.computeIfAbsent(c, k -> new HashSet(4)).add(w);
        }
        this.registerPointsOfWay(w);
        this.checkIfUsableLink(w, highwayTag, directionSuffix);
    }

    private void checkIfUsableLink(Way w, String highwayTag, String directionSuffix) {
        if (!linkTypes.contains(highwayTag)) {
            return;
        }
        String destinationLanes = "destination:lanes";
        String standardTagKey = "destination";
        String destSourceTagKey = "destination";
        String destHint = w.getTag("destination");
        if (destHint == null) {
            destSourceTagKey = "destination:lanes";
            String destLanesTag = w.getTag(destSourceTagKey);
            if (destLanesTag == null && directionSuffix != null) {
                destSourceTagKey = destSourceTagKey + ":" + directionSuffix;
                destLanesTag = w.getTag(destSourceTagKey);
            }
            if (destLanesTag != null && !destLanesTag.contains("|")) {
                destHint = destLanesTag;
            }
            if (destHint == null && directionSuffix != null) {
                destSourceTagKey = "destination:" + directionSuffix;
                destHint = w.getTag(destSourceTagKey);
            }
            if (destHint == null) {
                destSourceTagKey = "destination:street";
                destHint = w.getTag(destSourceTagKey);
            }
        }
        if (destHint != null) {
            w.addTag(TKM_DEST_HINT_WORK, destHint);
            this.destinationLinkWays.add(w);
            if (log.isDebugEnabled() && !"destination".equals(destSourceTagKey)) {
                String msg = destSourceTagKey.startsWith("destination:lanes") ? "as destination tag because there is one lane information only." : "as destination tag.";
                log.debug("Use", destSourceTagKey, msg, "Way", w.getId(), w.toTagString());
            }
        }
    }

    private void registerPointsOfWay(Way w) {
        for (Coord c : w.getPoints()) {
            this.wayNodes.computeIfAbsent(c, k -> new HashSet()).add(w);
        }
    }

    private void removePointsFromWay(Way w, int from, int to) {
        for (Coord c : w.getPoints().subList(from, to)) {
            this.wayNodes.get(c).remove(w);
        }
        w.getPoints().subList(from, to).clear();
    }

    private void changeWayIdInRelations(Way oldWay, Way newWay) {
        Object wayRestrictions = this.restrictions.get(oldWay.getId());
        if (wayRestrictions.isEmpty()) {
            return;
        }
        if (oldWay.isViaWay()) {
            log.error("internal error: via way is split in", this.getClass().getSimpleName());
        }
        for (RestrictionRelation rr : new ArrayList(wayRestrictions)) {
            Coord lastPointNewWay = newWay.getFirstPoint();
            List<Coord> viaCoords = rr.getViaCoords();
            for (Coord via : viaCoords) {
                if (via != lastPointNewWay) continue;
                if (rr.isToWay(oldWay.getId())) {
                    log.debug("Change to-way", oldWay.getId(), "to", newWay.getId(), "for relation", rr.getId(), "at", lastPointNewWay.toOSMURL());
                    rr.replaceWay(oldWay.getId(), newWay.getId());
                    this.restrictions.removeMapping(oldWay.getId(), rr);
                    this.restrictions.add(newWay.getId(), rr);
                    continue;
                }
                if (!rr.isFromWay(oldWay.getId())) continue;
                log.debug("Change from-way", oldWay.getId(), "to", newWay.getId(), "for relation", rr.getId(), "at", lastPointNewWay.toOSMURL());
                rr.replaceWay(oldWay.getId(), newWay.getId());
                this.restrictions.removeMapping(oldWay.getId(), rr);
                this.restrictions.add(newWay.getId(), rr);
            }
        }
    }

    private Way cutoffWay(Way w, double cutLength, double maxLength) {
        if (w.getPoints().size() < 2) {
            return null;
        }
        if (w.getPoints().size() >= 3) {
            Coord cutPoint;
            Coord firstPoint = w.getPoints().get(0);
            double dist = firstPoint.distance(cutPoint = w.getPoints().get(1));
            if (dist <= maxLength) {
                Way precedingWay = new Way(w.getOriginalId(), w.getPoints().subList(0, 2));
                precedingWay.markAsGeneratedFrom(w);
                precedingWay.copyTags(w);
                this.saver.addWay(precedingWay);
                this.removePointsFromWay(w, 0, 1);
                this.registerPointsOfWay(precedingWay);
                this.changeWayIdInRelations(w, precedingWay);
                log.debug("Cut way", w, "at existing point 1. New way:", precedingWay);
                return precedingWay;
            }
            log.debug("Cannot cut way", w, "on existing nodes because the first distance is too big:", dist);
        }
        double startSegmentLength = 0.0;
        Coord lastC = w.getFirstPoint();
        for (int i = 1; i < w.getPoints().size(); ++i) {
            Coord c = w.getPoints().get(i);
            double segmentLength = lastC.distance(c);
            if (startSegmentLength + segmentLength >= cutLength) {
                double frac = (cutLength - startSegmentLength) / segmentLength;
                Coord cConnection = lastC.makeBetweenPoint(c, frac);
                Coord alternative = ExtNumbers.rasterLineNearPoint(c, lastC, cConnection, false);
                if (alternative != null) {
                    cConnection = alternative;
                }
                w.getPoints().add(i, cConnection);
                Way precedingWay = new Way(w.getOriginalId(), new ArrayList<Coord>(w.getPoints().subList(0, i + 1)));
                precedingWay.markAsGeneratedFrom(w);
                precedingWay.copyTags(w);
                this.saver.addWay(precedingWay);
                this.removePointsFromWay(w, 0, i);
                this.registerPointsOfWay(precedingWay);
                this.changeWayIdInRelations(w, precedingWay);
                return precedingWay;
            }
            lastC = c;
        }
        return null;
    }

    private boolean isTaggedAsExit(Node node) {
        return "motorway_junction".equals(node.getTag(TK_HIGHWAY)) && (node.getTag("ref") != null || this.nameFinder.getName(node) != null || node.getTag(TK_EXIT_TO) != null);
    }

    private void processWays() {
        this.cleanupLinkDestWays();
        this.createExitHints();
        this.createDestinationHints();
    }

    private void cleanupLinkDestWays() {
        ArrayDeque<Way> linksWithDestination = new ArrayDeque<Way>(this.destinationLinkWays);
        log.debug(this.destinationLinkWays.size(), "links with destination tag");
        while (!linksWithDestination.isEmpty()) {
            Coord c;
            Set<Way> nextWays;
            Way linkWay = (Way)linksWithDestination.poll();
            String destination = linkWay.getTag(TKM_DEST_HINT_WORK);
            if (log.isDebugEnabled()) {
                log.debug("Check way", linkWay.getId(), linkWay.toTagString());
            }
            if ((nextWays = this.adjacentWays.get(c = LinkDestinationHook.isOnewayOppositeDirection(linkWay) ? linkWay.getFirstPoint() : linkWay.getLastPoint())) == null) continue;
            for (Way connectedWay : nextWays) {
                boolean removed;
                Coord c2;
                boolean startEndConnection;
                String nextDest = connectedWay.getTag(TKM_DEST_HINT_WORK);
                if (log.isDebugEnabled()) {
                    log.debug("Followed by", connectedWay.getId(), connectedWay.toTagString());
                }
                if (!(startEndConnection = c == (c2 = LinkDestinationHook.isOnewayOppositeDirection(connectedWay) ? connectedWay.getLastPoint() : connectedWay.getFirstPoint())) || connectedWay.equals(linkWay) || !connectedWay.getTag(TK_HIGHWAY).endsWith("_link") || !destination.equals(nextDest) || !(removed = this.destinationLinkWays.remove(connectedWay)) || !log.isDebugEnabled()) continue;
                log.debug("Removed", connectedWay.getId(), connectedWay.toTagString());
            }
        }
        log.debug(this.destinationLinkWays.size(), "links with destination tag after cleanup");
    }

    private void createExitHints() {
        if (!this.processExits) {
            return;
        }
        ArrayList<String> hwSorted = new ArrayList<String>(highwayTypes);
        for (Node exitNode : this.saver.getNodes().values()) {
            if (!this.isTaggedAsExit(exitNode) || !this.saver.getBoundingBox().contains(exitNode.getLocation())) continue;
            this.processExitNode(exitNode, hwSorted);
        }
    }

    private void processExitNode(Node exitNode, List<String> hwSorted) {
        Set<Way> exitWays = this.adjacentWays.get(exitNode.getLocation());
        if (exitWays == null) {
            log.debug("Exit node", exitNode, "has no connected ways. Skip it.");
            return;
        }
        String exitTo = exitNode.getTag(TK_EXIT_TO);
        if (exitTo != null) {
            int countMatches = 0;
            int preferred = Integer.MAX_VALUE;
            for (Way w : exitWays) {
                String hw = w.getTag(TK_HIGHWAY);
                int pos = hwSorted.indexOf(hw);
                if (pos < preferred) {
                    preferred = pos;
                    countMatches = 1;
                    continue;
                }
                if (pos != preferred) continue;
                ++countMatches;
            }
            if (countMatches != 1) {
                exitTo = null;
            }
        }
        for (Way w : exitWays) {
            this.destinationLinkWays.remove(w);
            if (!LinkDestinationHook.canSplit(w)) continue;
            this.processExitWay(exitNode, w, exitTo);
        }
    }

    private void processExitWay(Node exitNode, Way w, String exitTo) {
        String highwayLinkTag = w.getTag(TK_HIGHWAY);
        if (highwayLinkTag.endsWith("_link")) {
            log.debug("Try to cut", highwayLinkTag, w, "into three parts for giving hint to exit", exitNode);
            Way hintWay = this.splitWay(w, "exit");
            if (hintWay != null) {
                this.fixDestHint(hintWay);
                hintWay.addTag("mkgmap:exit_hint", "true");
                if (exitNode.getTag("ref") != null) {
                    hintWay.addTag("mkgmap:exit_hint_ref", exitNode.getTag("ref"));
                }
                if (exitTo != null) {
                    hintWay.addTag("mkgmap:exit_hint_exit_to", exitTo);
                }
                if (this.nameFinder.getName(exitNode) != null) {
                    hintWay.addTag("mkgmap:exit_hint_name", this.nameFinder.getName(exitNode));
                }
                if (log.isInfoEnabled()) {
                    log.info("Cut off exit hint way", hintWay, hintWay.toTagString());
                }
            }
        }
    }

    private String fixDestHint(Way hintWay) {
        if (this.processDestinations) {
            String hint = hintWay.getTag(TKM_DEST_HINT_WORK);
            if (hint != null) {
                hintWay.deleteTag(TKM_DEST_HINT_WORK);
                hintWay.addTag("mkgmap:dest_hint", hint);
            }
            return hint;
        }
        return null;
    }

    private void createDestinationHints() {
        if (!this.processDestinations) {
            return;
        }
        while (!this.destinationLinkWays.isEmpty()) {
            Way w = (Way)this.destinationLinkWays.iterator().next();
            this.destinationLinkWays.remove(w);
            String highwayLinkTag = w.getTag(TK_HIGHWAY);
            if (!LinkDestinationHook.canSplit(w) || !highwayLinkTag.endsWith("_link")) continue;
            log.debug("Try to cut", highwayLinkTag, w, "into three parts for giving hint");
            Way hintWay = this.splitWay(w, "destination");
            if (hintWay == null) continue;
            String hint = this.fixDestHint(hintWay);
            if (hint == null) {
                log.error("Internal error in process_destination with way", hintWay);
            }
            if (!log.isInfoEnabled()) continue;
            log.info("Cut off exit hint way", hintWay, hintWay.toTagString());
        }
    }

    private Way splitWay(Way w, String hintType) {
        double cut2;
        double wayLength = w.calcLengthInMetres();
        double cut1 = Math.min(wayLength / 2.0, 20.0);
        Way wayPart1 = this.cutoffWay(w, cut1, cut2 = Math.min(wayLength, 100.0));
        if (wayPart1 == null) {
            log.info("Way", w, "is too short to cut at least", cut1, "m from it. Cannot create", hintType, "hint.");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Cut off way", wayPart1, wayPart1.toTagString());
        }
        Way hintWay = w;
        if (wayLength > 50.0) {
            hintWay = this.cutoffWay(w, 10.0, 50.0);
        }
        if (hintWay == null) {
            log.info("Way", w, "is too short to cut at least 20m from it. Cannot create", hintType, "hint.");
        }
        return hintWay;
    }

    private static boolean canSplit(Way w) {
        if (LinkDestinationHook.isNotOneway(w)) {
            log.warn("Ignore way", w, "because it is not oneway");
            return false;
        }
        if (w.isViaWay()) {
            log.warn("Ignore way", w, "because it is a via way in a restriction  relation");
            return false;
        }
        return w.calcLengthInMetres() >= 0.3;
    }

    private void cleanup() {
        this.adjacentWays = null;
        this.wayNodes = null;
        this.destinationLinkWays = null;
        this.saver = null;
        this.nameFinder = null;
    }

    @Override
    public Set<String> getUsedTags() {
        if (!this.processDestinations && !this.processExits) {
            return Collections.emptySet();
        }
        HashSet<String> tags = new HashSet<String>();
        tags.add("highway");
        tags.add("oneway");
        tags.add("destination");
        tags.add("destination:lanes");
        tags.add("destination:lanes:forward");
        tags.add("destination:lanes:backward");
        tags.add("destination:forward");
        tags.add("destination:backward");
        tags.add("destination:street");
        if (this.processExits) {
            tags.add("exit_to");
            tags.add("ref");
        }
        return tags;
    }

    @Override
    public void end() {
        log.info((Object)"LinkDestinationHook started");
        this.retrieveWaysAndRelations();
        this.processWays();
        this.cleanup();
        log.info((Object)"LinkDestinationHook finished");
    }

    private static boolean isOnewayInDirection(Way w) {
        if (w.tagIsLikeYes(TK_ONEWAY)) {
            return true;
        }
        String onewayTag = w.getTag(TK_ONEWAY);
        String highwayTag = w.getTag(TK_HIGHWAY);
        return onewayTag == null && highwayTag != null && ("motorway".equals(highwayTag) || "motorway_link".equals(highwayTag));
    }

    private static boolean isOnewayOppositeDirection(Way w) {
        return "-1".equals(w.getTag(TK_ONEWAY));
    }

    private static boolean isNotOneway(Way w) {
        return "no".equals(w.getTag(TK_ONEWAY)) || !LinkDestinationHook.isOnewayInDirection(w) && !LinkDestinationHook.isOnewayOppositeDirection(w);
    }
}

