/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.hgt;

import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.hgt.HGTReader;

public class HGTConverter {
    private static final Logger log = Logger.getLogger(HGTConverter.class);
    protected static final double FACTOR = 8.381903171539307E-8;
    private short[] noHeights = new short[]{Short.MIN_VALUE};
    private HGTReader[][] readers;
    private final int minLat32;
    private final int minLon32;
    private final int res;
    private final java.awt.geom.Area demArea;
    private short outsidePolygonHeight = (short)Short.MIN_VALUE;
    private int lastRow = -1;
    private int pointsDistanceLat;
    private int pointsDistanceLon;
    private boolean useComplexInterpolation;
    private final double[][] eleArray = new double[4][4];
    private int statPoints;
    private int statBicubic;
    private int statBilinear;
    private int statVoid;
    private int statRdrNull;
    private int statRdrRes;
    private InterpolationMethod interpolationMethod = InterpolationMethod.BICUBIC;

    public HGTConverter(String paths, Area bbox, java.awt.geom.Area demPolygonMapUnits, double extra) {
        int minLat = (int)Math.floor(Utils.toDegrees(bbox.getMinLat()) - extra);
        int minLon = (int)Math.floor(Utils.toDegrees(bbox.getMinLong()) - extra);
        int maxLat = (int)Math.ceil(Utils.toDegrees(bbox.getMaxLat()) + extra);
        int maxLon = (int)Math.ceil(Utils.toDegrees(bbox.getMaxLong()) + extra);
        if (minLat < -90) {
            minLat = -90;
        }
        if (maxLat > 90) {
            maxLat = 90;
        }
        if (minLon < -180) {
            minLon = -180;
        }
        if (maxLon > 180) {
            maxLon = 180;
        }
        this.minLat32 = Utils.toMapUnit(minLat) * 256;
        this.minLon32 = Utils.toMapUnit(minLon) * 256;
        int dimLat = maxLat - minLat;
        int dimLon = maxLon - minLon;
        this.readers = new HGTReader[dimLat][dimLon];
        this.demArea = demPolygonMapUnits;
        int maxRes = -1;
        for (int row = 0; row < dimLat; ++row) {
            int lat = row + minLat;
            for (int col = 0; col < dimLon; ++col) {
                HGTReader rdr;
                int lon = col + minLon;
                Area rdrBbox = new Area((double)lat, (double)lon, (double)lat + 1.0, (double)lon + 1.0);
                int testMode = this.intersectsPoly(rdrBbox);
                if (testMode == 0) continue;
                this.readers[row][col] = rdr = new HGTReader(lat, lon, paths);
                maxRes = Math.max(maxRes, rdr.getRes());
            }
        }
        this.res = maxRes;
    }

    public void setInterpolationMethod(InterpolationMethod interpolationMethod) {
        this.interpolationMethod = interpolationMethod;
        this.useComplexInterpolation = interpolationMethod != InterpolationMethod.BILINEAR;
    }

    protected short getElevation(int lat32, int lon32) {
        short s;
        short s2;
        boolean filled;
        int row = (int)((double)(lat32 - this.minLat32) * 8.381903171539307E-8);
        int col = (int)((double)(lon32 - this.minLon32) * 8.381903171539307E-8);
        HGTReader rdr = this.readers[row][col];
        if (rdr == null) {
            return this.outsidePolygonHeight;
        }
        int detectedRes = rdr.getRes();
        rdr.prepRead();
        if (detectedRes <= 0) {
            return 0;
        }
        int resX = rdr.getResX();
        int resY = rdr.getResY();
        this.lastRow = row;
        double scaleX = (double)resX * 8.381903171539307E-8;
        double scaleY = (double)resY * 8.381903171539307E-8;
        double y1 = (double)(lat32 - this.minLat32) * scaleY - (double)(row * resY);
        double x1 = (double)(lon32 - this.minLon32) * scaleX - (double)(col * resX);
        int xLeft = (int)x1;
        int yBottom = (int)y1;
        double qx = x1 - (double)xLeft;
        double qy = y1 - (double)yBottom;
        int n = Short.MIN_VALUE;
        ++this.statPoints;
        if (this.useComplexInterpolation && (filled = this.fillArray(rdr, row, col, xLeft, yBottom))) {
            s2 = (short)Math.round(HGTConverter.bicubicInterpolation(this.eleArray, qx, qy));
            ++this.statBicubic;
        }
        if (s2 == Short.MIN_VALUE) {
            int xRight = xLeft + 1;
            int yTop = yBottom + 1;
            short hLT = rdr.ele(xLeft, yTop);
            short hRT = rdr.ele(xRight, yTop);
            short hLB = rdr.ele(xLeft, yBottom);
            short hRB = rdr.ele(xRight, yBottom);
            s = HGTConverter.interpolatedHeight(qx, qy, hLT, hRT, hRB, hLB);
            ++this.statBilinear;
            if (s == Short.MIN_VALUE) {
                ++this.statVoid;
            }
        }
        if (s == Short.MIN_VALUE && log.isLoggable(Level.WARNING)) {
            double lon = (double)lon32 * 8.381903171539307E-8;
            double lat = (double)lat32 * 8.381903171539307E-8;
            Coord c = new Coord(lat, lon);
            log.warn("height interpolation returns void at", c);
        }
        return s;
    }

    private boolean fillArray(HGTReader rdr, int row, int col, int xLeft, int yBottom) {
        short h;
        int y;
        int detectedRes = rdr.getRes();
        int resX = rdr.getResX();
        int resY = rdr.getResY();
        int minX = 0;
        int minY = 0;
        int maxX = 3;
        int maxY = 3;
        boolean inside = true;
        if (xLeft == 0) {
            if (col <= 0) {
                return false;
            }
            minX = 1;
            inside = false;
        } else if (xLeft == resX - 1) {
            if (col + 1 >= this.readers[0].length) {
                return false;
            }
            maxX = 2;
            inside = false;
        }
        if (yBottom == 0) {
            if (row <= 0) {
                return false;
            }
            minY = 1;
            inside = false;
        } else if (yBottom == resY - 1) {
            if (row + 1 >= this.readers.length) {
                return false;
            }
            maxY = 2;
            inside = false;
        }
        for (int x = minX; x <= maxX; ++x) {
            for (y = minY; y <= maxY; ++y) {
                h = rdr.ele(xLeft + x - 1, yBottom + y - 1);
                if (h == Short.MIN_VALUE) {
                    return false;
                }
                this.eleArray[x][y] = h;
            }
        }
        if (inside) {
            return true;
        }
        if (xLeft > 0 && xLeft < resX - 1) {
            int x;
            if (yBottom == 0) {
                HGTReader rdrBB = this.prepReader(detectedRes, row - 1, col);
                if (rdrBB == null) {
                    return false;
                }
                for (x = 0; x <= 3; ++x) {
                    h = rdrBB.ele(xLeft + x - 1, resY - 1);
                    if (h == Short.MIN_VALUE) {
                        return false;
                    }
                    this.eleArray[x][0] = h;
                }
            } else if (yBottom == resY - 1) {
                HGTReader rdrTT = this.prepReader(detectedRes, row + 1, col);
                if (rdrTT == null) {
                    return false;
                }
                for (x = 0; x <= 3; ++x) {
                    h = rdrTT.ele(xLeft + x - 1, 1);
                    if (h == Short.MIN_VALUE) {
                        return false;
                    }
                    this.eleArray[x][3] = h;
                }
            }
        }
        if (yBottom > 0 && yBottom < resY - 1) {
            if (xLeft == 0) {
                HGTReader rdrLL = this.prepReader(detectedRes, row, col - 1);
                if (rdrLL == null) {
                    return false;
                }
                for (y = 0; y <= 3; ++y) {
                    h = rdrLL.ele(resX - 1, yBottom + y - 1);
                    if (h == Short.MIN_VALUE) {
                        return false;
                    }
                    this.eleArray[0][y] = h;
                }
            } else if (xLeft == resX - 1) {
                HGTReader rdrRR = this.prepReader(detectedRes, row, col + 1);
                if (rdrRR == null) {
                    return false;
                }
                for (y = 0; y <= 3; ++y) {
                    h = rdrRR.ele(1, yBottom + y - 1);
                    if (h == Short.MIN_VALUE) {
                        return false;
                    }
                    this.eleArray[3][y] = h;
                }
            }
        }
        if (xLeft == 0) {
            if (yBottom == 0) {
                HGTReader rdrLL = this.prepReader(detectedRes, row, col - 1);
                if (rdrLL == null) {
                    return false;
                }
                for (y = 1; y <= 3; ++y) {
                    h = rdrLL.ele(resX - 1, yBottom + y - 1);
                    if (h == Short.MIN_VALUE) {
                        return false;
                    }
                    this.eleArray[0][y] = h;
                }
                HGTReader rdrBB = this.prepReader(detectedRes, row - 1, col);
                if (rdrBB == null) {
                    return false;
                }
                for (int x = 1; x <= 3; ++x) {
                    h = rdrBB.ele(xLeft + x - 1, resY - 1);
                    if (h == Short.MIN_VALUE) {
                        return false;
                    }
                    this.eleArray[x][0] = h;
                }
                HGTReader rdrLB = this.prepReader(detectedRes, row - 1, col - 1);
                if (rdrLB == null) {
                    return false;
                }
                h = rdrLB.ele(resX - 1, resY - 1);
                if (h == Short.MIN_VALUE) {
                    return false;
                }
                this.eleArray[0][0] = h;
            } else if (yBottom == resY - 1) {
                HGTReader rdrLL = this.prepReader(detectedRes, row, col - 1);
                if (rdrLL == null) {
                    return false;
                }
                for (y = 0; y <= 2; ++y) {
                    h = rdrLL.ele(resX - 1, yBottom + y - 1);
                    if (h == Short.MIN_VALUE) {
                        return false;
                    }
                    this.eleArray[0][y] = h;
                }
                HGTReader rdrTT = this.prepReader(detectedRes, row + 1, col);
                if (rdrTT == null) {
                    return false;
                }
                for (int x = 1; x <= 3; ++x) {
                    h = rdrTT.ele(xLeft + x - 1, 1);
                    if (h == Short.MIN_VALUE) {
                        return false;
                    }
                    this.eleArray[x][3] = h;
                }
                HGTReader rdrLT = this.prepReader(detectedRes, row + 1, col - 1);
                if (rdrLT == null) {
                    return false;
                }
                h = rdrLT.ele(resX - 1, 1);
                if (h == Short.MIN_VALUE) {
                    return false;
                }
                this.eleArray[0][3] = h;
            }
        } else if (xLeft == resX - 1) {
            if (yBottom == 0) {
                HGTReader rdrRR = this.prepReader(detectedRes, row, col + 1);
                if (rdrRR == null) {
                    return false;
                }
                for (y = 1; y <= 3; ++y) {
                    h = rdrRR.ele(1, yBottom + y - 1);
                    if (h == Short.MIN_VALUE) {
                        return false;
                    }
                    this.eleArray[3][y] = h;
                }
                HGTReader rdrBB = this.prepReader(detectedRes, row - 1, col);
                if (rdrBB == null) {
                    return false;
                }
                for (int x = 0; x <= 2; ++x) {
                    h = rdrBB.ele(xLeft + x - 1, resY - 1);
                    if (h == Short.MIN_VALUE) {
                        return false;
                    }
                    this.eleArray[x][0] = h;
                }
                HGTReader rdrRB = this.prepReader(detectedRes, row - 1, col + 1);
                if (rdrRB == null) {
                    return false;
                }
                h = rdrRB.ele(1, resY - 1);
                if (h == Short.MIN_VALUE) {
                    return false;
                }
                this.eleArray[3][0] = h;
            } else if (yBottom == resY - 1) {
                HGTReader rdrRR = this.prepReader(detectedRes, row, col + 1);
                if (rdrRR == null) {
                    return false;
                }
                for (y = 0; y <= 2; ++y) {
                    h = rdrRR.ele(1, yBottom + y - 1);
                    if (h == Short.MIN_VALUE) {
                        return false;
                    }
                    this.eleArray[3][y] = h;
                }
                HGTReader rdrTT = this.prepReader(detectedRes, row + 1, col);
                if (rdrTT == null) {
                    return false;
                }
                for (int x = 0; x <= 2; ++x) {
                    h = rdrTT.ele(xLeft + x - 1, 1);
                    if (h == Short.MIN_VALUE) {
                        return false;
                    }
                    this.eleArray[x][3] = h;
                }
                HGTReader rdrRT = this.prepReader(detectedRes, row + 1, col + 1);
                if (rdrRT == null) {
                    return false;
                }
                h = rdrRT.ele(1, 1);
                if (h == Short.MIN_VALUE) {
                    return false;
                }
                this.eleArray[3][3] = h;
            }
        }
        return true;
    }

    private HGTReader prepReader(int res, int row, int col) {
        if (row >= this.readers.length) {
            log.error("invalid array index for row", row);
            return null;
        }
        if (col >= this.readers[row].length) {
            log.error("invalid array index for col", row);
            return null;
        }
        HGTReader rdr = this.readers[row][col];
        if (rdr == null) {
            ++this.statRdrNull;
            return null;
        }
        if (res != rdr.getRes()) {
            ++this.statRdrRes;
            return null;
        }
        rdr.prepRead();
        if (row > this.lastRow) {
            this.lastRow = row;
        }
        return rdr;
    }

    public void freeMem() {
        log.info((Object)"trying to free mem for hgt buffers");
        for (int i = this.readers.length - 1; i > this.lastRow; --i) {
            for (HGTReader r : this.readers[i]) {
                if (r == null) continue;
                r.freeBuf();
            }
        }
    }

    private static short interpolatedHeight(double qx, double qy, int hlt, int hrt, int hrb, int hlb) {
        if (hlb == Short.MIN_VALUE) {
            if (hrb == Short.MIN_VALUE || hlt == Short.MIN_VALUE || hrt == Short.MIN_VALUE) {
                if (hrt != Short.MIN_VALUE && hlt != Short.MIN_VALUE && qy > 0.5) {
                    return (short)Math.round((1.0 - qx) * (double)hlt + qx * (double)hrt);
                }
                if (hrt != Short.MIN_VALUE && hrb != Short.MIN_VALUE && qx > 0.5) {
                    return (short)Math.round((1.0 - qy) * (double)hrb + qy * (double)hrt);
                }
                return (short)(qx < 0.5 ? (qy < 0.5 ? hlb : hlt) : (qy < 0.5 ? hrb : hrt));
            }
            if (qx + qy < 0.4) {
                return Short.MIN_VALUE;
            }
            hlb = hlt + hrb - hrt;
        } else if (hrt == Short.MIN_VALUE) {
            if (hlb == Short.MIN_VALUE || hrb == Short.MIN_VALUE || hlt == Short.MIN_VALUE) {
                if (hlb != Short.MIN_VALUE && hrb != Short.MIN_VALUE && qy < 0.5) {
                    return (short)Math.round((1.0 - qx) * (double)hlb + qx * (double)hrb);
                }
                if (hlb != Short.MIN_VALUE && hlt != Short.MIN_VALUE && qx < 0.5) {
                    return (short)Math.round((1.0 - qy) * (double)hlb + qy * (double)hlt);
                }
                return (short)(qx < 0.5 ? (qy < 0.5 ? hlb : hlt) : (qy < 0.5 ? hrb : hrt));
            }
            if (qx + qy > 1.6) {
                return Short.MIN_VALUE;
            }
            hrt = hlt + hrb - hlb;
        } else if (hrb == Short.MIN_VALUE) {
            if (hlb == Short.MIN_VALUE || hlt == Short.MIN_VALUE || hrt == Short.MIN_VALUE) {
                if (hlt != Short.MIN_VALUE && hrt != Short.MIN_VALUE && qy > 0.5) {
                    return (short)Math.round((1.0 - qx) * (double)hlt + qx * (double)hrt);
                }
                if (hlt != Short.MIN_VALUE && hlb != Short.MIN_VALUE && qx < 0.5) {
                    return (short)Math.round((1.0 - qy) * (double)hlb + qy * (double)hlt);
                }
                return (short)(qx < 0.5 ? (qy < 0.5 ? hlb : hlt) : (qy < 0.5 ? hrb : hrt));
            }
            if (qy < qx - 0.4) {
                return Short.MIN_VALUE;
            }
            hrb = hlb + hrt - hlt;
        } else if (hlt == Short.MIN_VALUE) {
            if (hlb == Short.MIN_VALUE || hrb == Short.MIN_VALUE || hrt == Short.MIN_VALUE) {
                if (hrb != Short.MIN_VALUE && hlb != Short.MIN_VALUE && qy < 0.5) {
                    return (short)Math.round((1.0 - qx) * (double)hlb + qx * (double)hrb);
                }
                if (hrb != Short.MIN_VALUE && hrt != Short.MIN_VALUE && qx > 0.5) {
                    return (short)Math.round((1.0 - qy) * (double)hrb + qy * (double)hrt);
                }
                return (short)(qx < 0.5 ? (qy < 0.5 ? hlb : hlt) : (qy < 0.5 ? hrb : hrt));
            }
            if (qy > qx + 0.6) {
                return Short.MIN_VALUE;
            }
            hlt = hlb + hrt - hrb;
        }
        double hxt = (1.0 - qx) * (double)hlt + qx * (double)hrt;
        double hxb = (1.0 - qx) * (double)hlb + qx * (double)hrb;
        return (short)Math.round((1.0 - qy) * hxb + qy * hxt);
    }

    public int getHighestRes() {
        return this.res;
    }

    private int intersectsPoly(Area bbox) {
        if (this.demArea == null) {
            return 2;
        }
        Rectangle2D.Double r = new Rectangle2D.Double(bbox.getMinLong(), bbox.getMinLat(), bbox.getWidth(), bbox.getHeight());
        if (this.demArea.contains(r)) {
            return 2;
        }
        if (this.demArea.intersects(r)) {
            return 1;
        }
        return 0;
    }

    public void setOutsidePolygonHeight(short outsidePolygonHeight) {
        this.outsidePolygonHeight = outsidePolygonHeight;
        this.noHeights[0] = outsidePolygonHeight;
    }

    public void startNewLevel(int pointDist) {
        this.clearStat();
        this.pointsDistanceLat = pointDist;
        this.pointsDistanceLon = pointDist;
        if (InterpolationMethod.AUTOMATIC == this.interpolationMethod) {
            int distHGTx3;
            if (this.res > 0 && (distHGTx3 = 0x20000000 / (15 * this.res)) + 20 > pointDist) {
                this.useComplexInterpolation = true;
                return;
            }
            this.useComplexInterpolation = false;
        }
    }

    private void clearStat() {
        this.statPoints = 0;
        this.statBicubic = 0;
        this.statBilinear = 0;
        this.statVoid = 0;
        this.statRdrNull = 0;
        this.statRdrRes = 0;
    }

    public void printStat() {
        log.info((Object)("DEM points: " + this.statPoints + "; bicubic " + this.statBicubic + ", no HGT " + (this.statRdrNull + this.statRdrRes) + "; bilinear " + this.statBilinear + ", voids " + this.statVoid + "; distance " + this.pointsDistanceLat));
    }

    public short[] getHeights(int lat32, int lon32, int height, int width) {
        java.awt.geom.Area testArea = null;
        if (this.demArea != null) {
            Rectangle2D.Double r = new Rectangle2D.Double((double)lon32 / 256.0 - 0.01, (double)(lat32 - height * this.pointsDistanceLat) / 256.0 - 0.01, (double)(width * this.pointsDistanceLon) / 256.0 + 0.02, (double)(height * this.pointsDistanceLat) / 256.0 + 0.02);
            if (!this.demArea.intersects(r)) {
                return this.noHeights;
            }
            if (!this.demArea.contains(r)) {
                testArea = new java.awt.geom.Area(r);
                testArea.intersect(this.demArea);
            }
        }
        short[] realHeights = new short[width * height];
        int count = 0;
        int py = lat32;
        for (int y = 0; y < height; ++y) {
            int px = lon32;
            for (int x = 0; x < width; ++x) {
                double yTest;
                double xTest;
                boolean needHeight = true;
                if (testArea != null && !testArea.contains(xTest = (double)px / 256.0, yTest = (double)py / 256.0)) {
                    needHeight = false;
                }
                if (lon32 > 0 && px <= 0) {
                    needHeight = false;
                }
                realHeights[count++] = needHeight ? this.getElevation(py, px) : this.outsidePolygonHeight;
                px += this.pointsDistanceLon;
            }
            py -= this.pointsDistanceLat;
        }
        return realHeights;
    }

    private static double cubicInterpolation(double[] p, double qx) {
        return p[1] + 0.5 * qx * (p[2] - p[0] + qx * (2.0 * p[0] - 5.0 * p[1] + 4.0 * p[2] - p[3] + qx * (3.0 * (p[1] - p[2]) + p[3] - p[0])));
    }

    private static double bicubicInterpolation(double[][] p, double qx, double qy) {
        double[] arr = new double[]{HGTConverter.cubicInterpolation(p[0], qy), HGTConverter.cubicInterpolation(p[1], qy), HGTConverter.cubicInterpolation(p[2], qy), HGTConverter.cubicInterpolation(p[3], qy)};
        return HGTConverter.cubicInterpolation(arr, qx);
    }

    public static enum InterpolationMethod {
        BILINEAR,
        BICUBIC,
        AUTOMATIC;

    }
}

