/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.net.URL;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.CombinedStyleFileLoader;
import uk.me.parabola.mkgmap.osmstyle.DirectoryFileLoader;
import uk.me.parabola.mkgmap.osmstyle.JarFileLoader;

public abstract class StyleFileLoader
implements Closeable {
    private static final Logger log = Logger.getLogger(StyleFileLoader.class);

    public static StyleFileLoader createStyleLoader(String loc, String name) throws FileNotFoundException {
        StyleFileLoader loader;
        if (loc == null) {
            return StyleFileLoader.createStyleLoader("classpath:styles", name);
        }
        File file = new File(loc);
        if (file.isDirectory()) {
            File dir = file;
            if (name != null) {
                dir = new File(file, name);
                if (!dir.exists()) {
                    throw new FileNotFoundException("style " + name + " not found in " + dir);
                }
                if (!dir.isDirectory()) {
                    dir = file;
                }
            }
            log.debug("style directory", dir);
            loader = new DirectoryFileLoader(dir);
        } else if (file.isFile()) {
            String loclc = loc.toLowerCase();
            if (loclc.endsWith(".style")) {
                if (name != null) {
                    throw new FileNotFoundException("no sub styles in a simple style file");
                }
                log.debug((Object)"a single file style");
                loader = new CombinedStyleFileLoader(loc);
            } else {
                log.debug("jar file", file);
                loader = new JarFileLoader(file.toURI().toString(), name);
            }
        } else {
            log.debug("style url location", loc);
            String s = loc.toLowerCase();
            if (s.startsWith("classpath:")) {
                log.debug((Object)"load style off classpath");
                StyleFileLoader loader2 = StyleFileLoader.classpathLoader(loc.substring(10), name);
                return loader2;
            }
            if (s.startsWith("jar:")) {
                loader = new JarFileLoader(loc, name);
            } else if (s.indexOf(58) > 0) {
                loader = new JarFileLoader(s, name);
            } else {
                throw new FileNotFoundException("no such file or path: " + loc);
            }
        }
        return loader;
    }

    public abstract Reader open(String var1) throws FileNotFoundException;

    @Override
    public abstract void close();

    public abstract String[] list();

    private static StyleFileLoader classpathLoader(String loc, String name) throws FileNotFoundException {
        ClassLoader classLoader;
        String path = loc;
        if (name != null) {
            path = loc + '/' + name + '/';
        }
        if ((classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            throw new FileNotFoundException("no classloader to find style");
        }
        URL url = classLoader.getResource(path);
        if (url == null && (url = (classLoader = StyleFileLoader.class.getClassLoader()).getResource(path)) == null) {
            throw new FileNotFoundException("Could not find style " + path);
        }
        String proto = url.getProtocol().toLowerCase();
        if ("jar".equals(proto)) {
            log.debug("classpath loading from jar with url", url);
            return new JarFileLoader(url);
        }
        if ("file".equals(proto)) {
            log.debug("classpath loading from directory", url.getPath());
            return new DirectoryFileLoader(new File(url.getPath()));
        }
        throw new FileNotFoundException("Could not load style from classpath");
    }
}

