/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.BitReader;
import uk.me.parabola.imgfmt.app.BufferedImgFileReader;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgReader;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.LBLFileReader;
import uk.me.parabola.imgfmt.app.lbl.POIRecord;
import uk.me.parabola.imgfmt.app.net.NETFileReader;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.trergn.ExtTypeAttributes;
import uk.me.parabola.imgfmt.app.trergn.MapObject;
import uk.me.parabola.imgfmt.app.trergn.Point;
import uk.me.parabola.imgfmt.app.trergn.Polygon;
import uk.me.parabola.imgfmt.app.trergn.Polyline;
import uk.me.parabola.imgfmt.app.trergn.RGNHeader;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.log.Logger;
import uk.me.parabola.util.EnhancedProperties;

public class RGNFileReader
extends ImgReader {
    private static final Logger log = Logger.getLogger(RGNFileReader.class);
    private final RGNHeader rgnHeader = new RGNHeader();
    private LBLFileReader lblFile;
    private NETFileReader netFile;
    private static final int FLAG_DIR = 64;

    public RGNFileReader(ImgChannel chan) {
        this.setHeader(this.rgnHeader);
        this.setReader(new BufferedImgFileReader(chan));
        this.rgnHeader.readHeader(this.getReader());
    }

    @Override
    public void config(EnhancedProperties props) {
    }

    public List<Point> pointsForSubdiv(Subdivision sd, boolean withExtType) {
        ArrayList<Point> list = new ArrayList<Point>();
        if (sd.hasIndPoints() || sd.hasPoints()) {
            RgnOffsets rgnOffsets = this.getOffsets(sd);
            this.fetchPointsCommon(sd, rgnOffsets.getIndPointStart(), rgnOffsets.getIndPointEnd(), list);
            this.fetchPointsCommon(sd, rgnOffsets.getPointStart(), rgnOffsets.getPointEnd(), list);
        }
        if (withExtType && sd.getExtTypePointsSize() > 0) {
            this.fetchPointsExtType(sd, list);
        }
        return list;
    }

    private void fetchPointsCommon(Subdivision sd, long start, long end, List<Point> points) {
        this.position(start);
        ImgFileReader reader = this.getReader();
        int number = points.size() + 1;
        while (this.position() < end) {
            Label l;
            Point p = new Point(sd);
            int t = reader.get1u();
            int val = reader.get3u();
            boolean hasSubtype = (val & 0x800000) != 0;
            boolean hasPoi = (val & 0x400000) != 0;
            int labelOffset = val & 0x3FFFFF;
            if (hasPoi) {
                POIRecord record = this.lblFile.fetchPoi(labelOffset);
                if (record != null) {
                    l = record.getNameLabel();
                    p.setPOIRecord(record);
                } else {
                    l = this.lblFile.fetchLabel(0);
                }
            } else {
                l = this.lblFile.fetchLabel(labelOffset);
            }
            p.setLabel(l);
            p.setDeltaLong(reader.get2s());
            p.setDeltaLat(reader.get2s());
            t <<= 8;
            if (hasSubtype) {
                int st = reader.get1u();
                t |= st;
            }
            p.setType(t);
            p.setNumber(number++);
            points.add(p);
        }
    }

    private void fetchPointsExtType(Subdivision sd, List<Point> points) {
        long start = this.rgnHeader.getExtTypePointsOffset() + sd.getExtTypePointsOffset();
        long end = start + (long)sd.getExtTypePointsSize();
        this.position(start);
        ImgFileReader reader = this.getReader();
        int number = points.size() + 1;
        while (this.position() < end) {
            Point p = new Point(sd);
            int type = reader.get1u() << 8;
            int b = reader.get1u();
            p.setType(type |= 65536 + (b & 0x1F));
            p.setDeltaLong(reader.get2s());
            p.setDeltaLat(reader.get2s());
            if ((b & 0x20) != 0) {
                Label l;
                boolean hasPoi;
                int labelOffset = reader.get3u();
                boolean bl = hasPoi = (labelOffset & 0x400000) != 0;
                if (hasPoi) {
                    POIRecord record = this.lblFile.fetchPoi(labelOffset);
                    if (record != null) {
                        l = record.getNameLabel();
                        p.setPOIRecord(record);
                    } else {
                        l = this.lblFile.fetchLabel(0);
                    }
                } else {
                    l = this.lblFile.fetchLabel(labelOffset);
                }
                p.setLabel(l);
            }
            if ((b & 0x80) != 0) {
                this.extractExtraBytes(reader, p);
            }
            p.setNumber(number++);
            points.add(p);
        }
    }

    public List<Polyline> linesForSubdiv(Subdivision div) {
        ArrayList<Polyline> list = new ArrayList<Polyline>();
        if (div.hasPolylines()) {
            RgnOffsets rgnOffsets = this.getOffsets(div);
            int start = rgnOffsets.getLineStart();
            int end = rgnOffsets.getLineEnd();
            this.position(start);
            while (this.position() < (long)end) {
                Polyline line = new Polyline(div);
                this.readLineCommon(this.getReader(), div, line);
                list.add(line);
            }
        }
        if (div.getExtTypeLinesSize() > 0) {
            int start = this.rgnHeader.getExtTypeLinesOffset() + div.getExtTypeLinesOffset();
            int end = start + div.getExtTypeLinesSize();
            this.position(start);
            while (this.position() < (long)end) {
                Polyline line = new Polyline(div);
                this.readLineCommonExtType(this.getReader(), div, line);
                list.add(line);
            }
        }
        return list;
    }

    public List<Polygon> shapesForSubdiv(Subdivision div, boolean witExtTypeData) {
        ArrayList<Polygon> list = new ArrayList<Polygon>();
        if (div.hasPolygons()) {
            RgnOffsets rgnOffsets = this.getOffsets(div);
            int start = rgnOffsets.getPolygonStart();
            int end = rgnOffsets.getPolygonEnd();
            this.position(start);
            while (this.position() < (long)end) {
                Polygon line = new Polygon(div);
                this.readLineCommon(this.getReader(), div, line);
                list.add(line);
                line.setNumber(list.size());
            }
        }
        if (witExtTypeData && div.getExtTypeAreasSize() > 0) {
            int start = this.rgnHeader.getExtTypeAreasOffset() + div.getExtTypeAreasOffset();
            int end = start + div.getExtTypeAreasSize();
            this.position(start);
            while (this.position() < (long)end) {
                Polygon line = new Polygon(div);
                this.readLineCommonExtType(this.getReader(), div, line);
                list.add(line);
            }
        }
        return list;
    }

    private void readLineCommon(ImgFileReader reader, Subdivision div, Polyline line) {
        Label label;
        boolean extra;
        int type = reader.get1u();
        if (line instanceof Polygon) {
            line.setType(type & 0x7F);
        } else {
            line.setType(type & 0x3F);
            line.setDirection((type & 0x40) != 0);
        }
        int labelOffset = reader.get3u();
        boolean bl = extra = (labelOffset & 0x400000) != 0;
        if ((labelOffset & 0x800000) == 0) {
            label = this.lblFile.fetchLabel(labelOffset & 0x7FFFFF);
        } else {
            int netoff = labelOffset & 0x3FFFFF;
            labelOffset = this.netFile.getLabelOffset(netoff);
            label = this.lblFile.fetchLabel(labelOffset);
            RoadDef roadDef = new RoadDef(0L, netoff, label.getText());
            line.setRoadDef(roadDef);
        }
        line.setLabel(label);
        line.setDeltaLong(reader.get2s());
        line.setDeltaLat(reader.get2s());
        int len = (type & 0x80) == 0 ? reader.get1u() : reader.get2u();
        int base = reader.get1u();
        byte[] bitstream = reader.get(len);
        BitReader br = new BitReader(bitstream);
        this.readBitStream(br, div.getShift(), line, extra, len, base);
    }

    private void readLineCommonExtType(ImgFileReader reader, Subdivision div, Polyline line) {
        int len;
        boolean hasLabel;
        int type = reader.get1u() << 8;
        int b1 = reader.get1u();
        boolean hasExtraBytes = (b1 & 0x80) != 0;
        boolean bl = hasLabel = (b1 & 0x20) != 0;
        if (!(line instanceof Polygon)) {
            line.setDirection((b1 & 0x40) != 0);
        }
        line.setType(type |= 65536 + (b1 & 0x1F));
        line.setDeltaLong(reader.get2s());
        line.setDeltaLat(reader.get2s());
        b1 = reader.get1u();
        if ((b1 & 1) != 0) {
            len = b1 >> 1 & 0x7F;
            assert (len < 127);
        } else {
            int b2 = reader.get1u();
            len = (b2 << 8) + b1 >> 2;
            assert (len >= 127);
        }
        assert (--len > 0);
        int base = reader.get1u();
        byte[] bitstream = reader.get(len);
        BitReader br = new BitReader(bitstream);
        this.readBitStream(br, div.getShift(), line, false, len, base);
        if (hasLabel) {
            int labelOffset = reader.get3u();
            Label label = this.lblFile.fetchLabel(labelOffset & 0x3FFFFF);
            line.setLabel(label);
        }
        if (hasExtraBytes) {
            this.extractExtraBytes(reader, line);
        }
    }

    void extractExtraBytes(ImgFileReader reader, MapObject o) {
        long pos = reader.position();
        StringBuilder sb = new StringBuilder();
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        byte b1 = reader.get();
        bytes.add(b1);
        if ((b1 & 0xE0) != 0) {
            do {
                b1 = reader.get();
                bytes.add(b1);
            } while (b1 != 1);
        } else if ((b1 & 0xA0) != 0) {
            bytes.add(reader.get());
            bytes.add(reader.get());
        } else if ((b1 & 0x80) != 0) {
            bytes.add(reader.get());
        }
        for (Byte b : bytes) {
            sb.append(String.format("%x", b));
        }
        ExtTypeAttributes eta = new ExtTypeAttributes(Collections.singletonMap("extra-bytes", sb.toString()), "data from img pos " + pos);
        o.setExtTypeAttributes(eta);
    }

    private void readBitStream(BitReader br, int shift, Polyline line, boolean extra, int len, int base) {
        int currLat = line.getLat();
        int currLon = line.getLong();
        log.debug((Object)String.format("Start point %.5f,%.5f", Utils.toDegrees(currLat), Utils.toDegrees(currLon)));
        if (extra) {
            line.addCoord(new CoordNode(currLat, currLon, 0, false, false));
        } else {
            line.addCoord(new Coord(currLat, currLon));
        }
        int xbase = 2;
        int n = base & 0xF;
        xbase = n <= 9 ? (xbase += n) : (xbase += 2 * n - 9);
        n = base >>> 4 & 0xF;
        int ybase = 2;
        ybase = n <= 9 ? (ybase += n) : (ybase += 2 * n - 9);
        if (len == 0) {
            return;
        }
        boolean xneg = false;
        boolean xsame = br.get1();
        if (xsame) {
            xneg = br.get1();
        } else {
            ++xbase;
        }
        boolean ysame = br.get1();
        boolean yneg = false;
        if (ysame) {
            yneg = br.get1();
        } else {
            ++ybase;
        }
        if (line.hasExtendedType()) {
            br.get1();
        }
        if (extra) {
            boolean firstextra = br.get1();
            log.debug("the first extra bit is", firstextra);
        }
        while (br.getBitPosition() <= 8 * len - ((extra ? 1 : 0) + xbase + ybase)) {
            int dy;
            int dx;
            br.getBitPosition();
            if (xsame) {
                dx = br.get(xbase);
                if (xneg) {
                    dx = -dx;
                }
            } else {
                dx = br.sget2(xbase);
            }
            if (ysame) {
                dy = br.get(ybase);
                if (yneg) {
                    dy = -dy;
                }
            } else {
                dy = br.sget2(ybase);
            }
            boolean isnode = false;
            if (extra) {
                isnode = br.get1();
            }
            if (!isnode && dx == 0 && dy == 0) continue;
            Coord coord = isnode ? new CoordNode(currLat, currLon, 0, false, false) : new Coord(currLat += dy << shift, currLon += dx << shift);
            line.addCoord(coord);
        }
        if (line instanceof Polygon) {
            line.addCoord(line.getPoints().get(0));
        }
    }

    private RgnOffsets getOffsets(Subdivision sd) {
        int off = sd.getStartRgnPointer();
        this.position(this.rgnHeader.getDataOffset() + off);
        return new RgnOffsets(sd);
    }

    public void setLblFile(LBLFileReader lblFile) {
        this.lblFile = lblFile;
    }

    public void setNetFile(NETFileReader netFile) {
        this.netFile = netFile;
    }

    private class RgnOffsets {
        private final int pointOffset;
        private int pointEnd;
        private int indPointOffset;
        private int indPointEnd;
        private int lineOffset;
        private int lineEnd;
        private int polygonOffset;
        private int polygonEnd;
        private final int start;
        private int headerLen;

        private RgnOffsets(Subdivision sd) {
            ImgFileReader reader = RGNFileReader.this.getReader();
            this.start = (int)RGNFileReader.this.position();
            this.pointOffset = 0;
            if (sd.needsIndPointPtr()) {
                this.indPointOffset = reader.get2u();
                this.headerLen += 2;
            }
            if (sd.needsPolylinePtr()) {
                this.lineOffset = reader.get2u();
                this.headerLen += 2;
            }
            if (sd.needsPolygonPtr()) {
                this.polygonOffset = reader.get2u();
                this.headerLen += 2;
            }
            if (sd.hasPoints()) {
                this.pointEnd = sd.hasIndPoints() ? this.indPointOffset : (sd.hasPolylines() ? this.lineOffset : (sd.hasPolygons() ? this.polygonOffset : sd.getEndRgnPointer() - sd.getStartRgnPointer()));
            }
            if (sd.hasIndPoints()) {
                this.indPointEnd = sd.hasPolylines() ? this.lineOffset : (sd.hasPolygons() ? this.polygonOffset : sd.getEndRgnPointer() - sd.getStartRgnPointer());
            }
            if (sd.hasPolylines()) {
                this.lineEnd = sd.hasPolygons() ? this.polygonOffset : sd.getEndRgnPointer() - sd.getStartRgnPointer();
            }
            if (sd.hasPolygons()) {
                this.polygonEnd = sd.getEndRgnPointer() - sd.getStartRgnPointer();
            }
        }

        public String toString() {
            return String.format("rgn div offsets: %x-%x/%x-%x/%x-%x/%x-%x", this.pointOffset, this.pointEnd, this.indPointOffset, this.indPointEnd, this.lineOffset, this.lineEnd, this.polygonOffset, this.polygonEnd);
        }

        public long getPointStart() {
            return this.pointOffset == 0 ? (long)(this.start + this.headerLen) : (long)(this.start + this.pointOffset);
        }

        public long getPointEnd() {
            return this.start + this.pointEnd;
        }

        public long getIndPointStart() {
            return this.indPointOffset == 0 ? (long)(this.start + this.headerLen) : (long)(this.start + this.indPointOffset);
        }

        public long getIndPointEnd() {
            return this.start + this.indPointEnd;
        }

        public int getLineStart() {
            return this.lineOffset == 0 ? this.start + this.headerLen : this.start + this.lineOffset;
        }

        public int getLineEnd() {
            return this.start + this.lineEnd;
        }

        public int getPolygonStart() {
            return this.polygonOffset == 0 ? this.start + this.headerLen : this.start + this.polygonOffset;
        }

        public int getPolygonEnd() {
            return this.start + this.polygonEnd;
        }
    }
}

