/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.net.RouteArc;
import uk.me.parabola.imgfmt.app.net.RouteRestriction;
import uk.me.parabola.log.Logger;

public class RouteNode
implements Comparable<RouteNode> {
    private static final Logger log = Logger.getLogger(RouteNode.class);
    private static final int MAX_DEST_CLASS_MASK = 7;
    private static final int F_BOUNDARY = 8;
    private static final int F_RESTRICTIONS = 16;
    private static final int F_LARGE_OFFSETS = 32;
    private static final int F_ARCS = 64;
    private static final int F_DISCARDED = 256;
    private int offsetNod1 = -1;
    private final List<RouteArc> arcs = new ArrayList<RouteArc>(4);
    private final List<RouteRestriction> restrictions = new ArrayList<RouteRestriction>();
    private int flags;
    private final CoordNode coord;
    private int latOff;
    private int lonOff;
    private byte nodeClass;
    private byte nodeGroup = (byte)-1;
    private boolean useCompactDirs = false;
    private int visitId;

    public RouteNode(Coord coord) {
        this.coord = (CoordNode)coord;
        this.setBoundary(this.coord.getOnBoundary() || this.coord.getOnCountryBorder());
    }

    private boolean haveLargeOffsets() {
        return (this.flags & 0x20) != 0;
    }

    protected void setBoundary(boolean b) {
        this.flags = b ? (this.flags |= 8) : (this.flags &= 0xF7);
    }

    public boolean isBoundary() {
        return (this.flags & 8) != 0;
    }

    public void addArc(RouteArc arc) {
        this.arcs.add(arc);
        byte cl = (byte)arc.getRoadDef().getRoadClass();
        if (log.isDebugEnabled()) {
            log.debug("adding arc", arc.getRoadDef(), cl);
        }
        if (cl > this.nodeClass) {
            this.nodeClass = cl;
        }
        this.flags |= 0x40;
    }

    public void addRestriction(RouteRestriction restr) {
        this.restrictions.add(restr);
        this.flags |= 0x10;
    }

    public List<RouteArc> getDirectArcsTo(RouteNode otherNode, long roadId) {
        ArrayList<RouteArc> result = new ArrayList<RouteArc>();
        for (RouteArc a : this.arcs) {
            if (!a.isDirect() || a.getDest() != otherNode || a.getRoadDef().getId() != roadId) continue;
            result.add(a);
        }
        return result;
    }

    public List<RouteArc> getDirectArcsOnWay(long roadId) {
        ArrayList<RouteArc> result = new ArrayList<RouteArc>();
        for (RouteArc a : this.arcs) {
            if (!a.isDirect() || a.getRoadDef().getId() != roadId) continue;
            result.add(a);
        }
        return result;
    }

    public RouteArc getDirectArcTo(RouteNode otherNode, RoadDef roadDef) {
        for (RouteArc a : this.arcs) {
            if (!a.isDirect() || a.getDest() != otherNode || a.getRoadDef() != roadDef) continue;
            return a;
        }
        return null;
    }

    public int boundSize() {
        return 6 + this.arcsSize() + this.restrSize();
    }

    private int arcsSize() {
        return this.arcs.stream().mapToInt(RouteArc::boundSize).sum();
    }

    private int restrSize() {
        return 2 * this.restrictions.size();
    }

    public void write(ImgFileWriter writer) {
        if (log.isDebugEnabled()) {
            log.debug("writing node, first pass, nod1", this.coord.getId());
        }
        this.offsetNod1 = writer.position();
        assert (this.offsetNod1 < 0x1000000) : "node offset doesn't fit in 3 bytes";
        assert ((this.flags & 0x100) == 0) : "attempt to write discarded node";
        writer.put1u(0);
        this.flags |= this.nodeClass & 7;
        if (this.flags == 0) {
            this.flags |= 0x20;
        }
        writer.put1u(this.flags);
        if (this.haveLargeOffsets()) {
            writer.put4(this.latOff << 16 | this.lonOff & 0xFFFF);
        } else {
            writer.put3s(this.latOff << 12 | this.lonOff & 0xFFF);
        }
        if (!this.arcs.isEmpty()) {
            IntArrayList initialHeadings = new IntArrayList(this.arcs.size() + 1);
            RouteArc lastArc = null;
            if (this.useCompactDirs) {
                for (RouteArc arc : this.arcs) {
                    if (lastArc == null || lastArc.getIndexA() != arc.getIndexA() || lastArc.isForward() != arc.isForward()) {
                        initialHeadings.add(RouteArc.compactDirFromDegrees(arc.getInitialHeading()));
                    }
                    lastArc = arc;
                }
                initialHeadings.add(0);
                lastArc = null;
            }
            this.arcs.get(this.arcs.size() - 1).setLast();
            int index = 0;
            for (RouteArc arc : this.arcs) {
                Byte compactedDir = null;
                if (this.useCompactDirs && (lastArc == null || lastArc.getIndexA() != arc.getIndexA() || lastArc.isForward() != arc.isForward())) {
                    if (index % 2 == 0) {
                        compactedDir = (byte)(initialHeadings.getInt(index) | initialHeadings.getInt(index + 1) << 4);
                    }
                    ++index;
                }
                arc.write(writer, lastArc, this.useCompactDirs, compactedDir);
                lastArc = arc;
            }
        }
        if (!this.restrictions.isEmpty()) {
            this.restrictions.get(this.restrictions.size() - 1).setLast();
            for (RouteRestriction restr : this.restrictions) {
                restr.writeOffset(writer);
            }
        }
    }

    public void writeNod3OrNod4(ImgFileWriter writer) {
        assert (this.isBoundary()) : "trying to write nod3 for non-boundary node";
        Utils.put3sLongitude(writer, this.coord.getLongitude());
        writer.put3s(this.coord.getLatitude());
        writer.put3u(this.offsetNod1);
    }

    public void discard() {
        this.flags |= 0x100;
        if (this.isBoundary()) {
            log.error("intermal error? boundary node at", this.coord, "is discarded");
        }
    }

    public boolean isDiscarded() {
        return (this.flags & 0x100) != 0;
    }

    public int getOffsetNod1() {
        if ((this.flags & 0x100) != 0) {
            return 0;
        }
        assert (this.offsetNod1 != -1) : "failed for node " + this.coord.getId() + " at " + this.coord;
        return this.offsetNod1;
    }

    public void setOffsets(Coord centralPoint) {
        if (log.isDebugEnabled()) {
            log.debug("center", centralPoint, ", coord", this.coord);
        }
        this.setLatOff(this.coord.getLatitude() - centralPoint.getLatitude());
        this.setLonOff(this.coord.getLongitude() - centralPoint.getLongitude());
    }

    public Coord getCoord() {
        return this.coord;
    }

    private void checkOffSize(int off) {
        if (off > 2047 || off < -2048) {
            this.flags |= 0x20;
        }
        assert (off <= Short.MAX_VALUE && off >= Short.MIN_VALUE);
    }

    private void setLatOff(int latOff) {
        if (log.isDebugEnabled()) {
            log.debug("lat off", Integer.toHexString(latOff));
        }
        this.latOff = latOff;
        this.checkOffSize(latOff);
    }

    private void setLonOff(int lonOff) {
        if (log.isDebugEnabled()) {
            log.debug("long off", Integer.toHexString(lonOff));
        }
        this.lonOff = lonOff;
        this.checkOffSize(lonOff);
    }

    public void writeSecond(ImgFileWriter writer) {
        for (RouteArc arc : this.arcs) {
            arc.writeSecond(writer);
        }
    }

    public int getNodeClass() {
        return this.nodeClass;
    }

    public Iterable<RouteArc> arcsIteration() {
        return this.arcs::iterator;
    }

    public List<RouteRestriction> getRestrictions() {
        return this.restrictions;
    }

    public String toString() {
        return String.valueOf(this.coord.getId()) + "@" + this.coord.toOSMURL();
    }

    @Override
    public int compareTo(RouteNode otherNode) {
        return this.coord.compareTo(otherNode.getCoord());
    }

    public void reportSimilarArcs() {
        for (int i = 0; i < this.arcs.size(); ++i) {
            RouteArc arci = this.arcs.get(i);
            RoadDef rdi = arci.getRoadDef();
            if (!arci.isDirect() || rdi.isSynthesised()) continue;
            for (int j = i + 1; j < this.arcs.size(); ++j) {
                RouteArc arcj = this.arcs.get(j);
                RoadDef rdj = arcj.getRoadDef();
                if (!arcj.isDirect() || rdj.isSynthesised() || arci.getDest() != arcj.getDest() || arci.getLength() != arcj.getLength() || arci.getPointsHash() != arcj.getPointsHash() || rdi.messagePreviouslyIssued("Similar arcs")) continue;
                log.diagnostic("Similar arcs " + rdi + " and " + rdj + " found at " + this.coord.toOSMURL());
            }
        }
    }

    public void addArcsToMajorRoads(RoadDef road) {
        assert (road.getNode() == this);
        RouteNode current = this;
        ArrayList<RouteNode> nodes = new ArrayList<RouteNode>();
        ArrayList<RouteArc> forwardArcs = new ArrayList<RouteArc>();
        IntArrayList forwardArcPositions = new IntArrayList();
        ArrayList<RouteArc> reverseArcs = new ArrayList<RouteArc>();
        IntArrayList reverseArcPositions = new IntArrayList();
        nodes.add(current);
        while (current != null) {
            RouteNode next = null;
            for (int i = 0; i < current.arcs.size(); ++i) {
                RouteArc arc = current.arcs.get(i);
                if (arc.getRoadDef() != road || !arc.isDirect()) continue;
                if (arc.isForward()) {
                    next = arc.getDest();
                    nodes.add(next);
                    forwardArcs.add(arc);
                    forwardArcPositions.add(i);
                    continue;
                }
                reverseArcPositions.add(i);
                reverseArcs.add(arc);
            }
            current = next;
        }
        if (nodes.size() < 3) {
            return;
        }
        ArrayList<RouteArc> newArcs = new ArrayList<RouteArc>();
        IntArrayList arcPositions = forwardArcPositions;
        ArrayList<RouteArc> roadArcs = forwardArcs;
        for (int dir = 0; dir < 2; ++dir) {
            int i = 0;
            while (i + 2 < nodes.size()) {
                RouteNode sourceNode = (RouteNode)nodes.get(i);
                RouteNode stepNode = (RouteNode)nodes.get(i + 1);
                RouteArc arcToStepNode = (RouteArc)roadArcs.get(i);
                assert (arcToStepNode.getDest() == stepNode);
                int currentClass = arcToStepNode.getArcDestClass();
                int finalClass = road.getRoadClass();
                if (finalClass > currentClass) {
                    newArcs.clear();
                    double partialArcLength = 0.0;
                    double pathLength = arcToStepNode.getLengthInMeter();
                    for (int j = i + 2; j < nodes.size(); ++j) {
                        RouteArc arcToDest = (RouteArc)roadArcs.get(j - 1);
                        partialArcLength += (double)arcToDest.getLengthInMeter();
                        pathLength += (double)arcToDest.getLengthInMeter();
                        int cl = ((RouteNode)nodes.get(j)).getGroup();
                        if (cl <= currentClass) continue;
                        if (cl > finalClass) {
                            cl = finalClass;
                        }
                        currentClass = cl;
                        RouteNode destNode = (RouteNode)nodes.get(j);
                        Coord c1 = sourceNode.getCoord();
                        Coord c2 = destNode.getCoord();
                        RouteArc newArc = new RouteArc(road, sourceNode, destNode, ((RouteArc)roadArcs.get(i)).getInitialHeading(), c1.bearingTo(c2), partialArcLength, pathLength, c1.distance(c2), c1.hashCode() + c2.hashCode());
                        if (arcToStepNode.isDirect()) {
                            arcToStepNode.setMaxDestClass(0);
                        } else {
                            newArc.setMaxDestClass(cl);
                        }
                        if (dir == 0) {
                            newArc.setForward();
                        }
                        newArc.setIndirect();
                        newArcs.add(newArc);
                        arcToStepNode = newArc;
                        partialArcLength = 0.0;
                        if (cl >= finalClass) break;
                    }
                    if (!newArcs.isEmpty()) {
                        int reverseArcPos;
                        int directArcPos = arcPositions.getInt(i);
                        assert (((RouteNode)nodes.get((int)i)).arcs.get(directArcPos).isDirect());
                        assert (((RouteNode)nodes.get((int)i)).arcs.get(directArcPos).getRoadDef() == ((RouteArc)newArcs.get(0)).getRoadDef());
                        assert (((RouteNode)nodes.get((int)i)).arcs.get(directArcPos).isForward() == ((RouteArc)newArcs.get(0)).isForward());
                        ((RouteNode)nodes.get((int)i)).arcs.addAll(directArcPos + 1, newArcs);
                        if (dir == 0 && i > 0 && directArcPos < (reverseArcPos = reverseArcPositions.getInt(i - 1))) {
                            reverseArcPositions.set(i - 1, reverseArcPos + newArcs.size());
                        }
                    }
                }
                ++i;
            }
            if (dir > 0) break;
            Collections.reverse(reverseArcs);
            Collections.reverse(reverseArcPositions);
            Collections.reverse(nodes);
            arcPositions = reverseArcPositions;
            roadArcs = reverseArcs;
        }
    }

    public int getGroup() {
        if (this.nodeGroup < 0) {
            if (this.arcs.isEmpty()) {
                this.nodeGroup = 0;
                return this.nodeGroup;
            }
            HashSet<RoadDef> roads = new HashSet<RoadDef>();
            for (RouteArc arc : this.arcs) {
                roads.add(arc.getRoadDef());
            }
            int[] classes = new int[5];
            int numClasses = 0;
            for (RoadDef road : roads) {
                int cl;
                int n = cl = road.getRoadClass();
                classes[n] = classes[n] + 1;
                int n2 = classes[n];
                if (n2 == 1) {
                    ++numClasses;
                    continue;
                }
                if (n2 <= 1 || cl <= this.nodeGroup) continue;
                this.nodeGroup = (byte)cl;
            }
            if (this.nodeGroup >= 0) {
                return this.nodeGroup;
            }
            if (numClasses == 1) {
                this.nodeGroup = this.nodeClass;
            } else {
                int n = 0;
                for (int cl = 4; cl >= 0; --cl) {
                    if (classes[cl] <= 0) continue;
                    if (n == 1) {
                        this.nodeGroup = (byte)cl;
                        break;
                    }
                    ++n;
                }
            }
        }
        return this.nodeGroup;
    }

    public List<RouteArc> getArcs() {
        return this.arcs;
    }

    public int hashCode() {
        return this.getCoord().getId();
    }

    public List<RouteArc> getDirectArcsBetween(RouteNode otherNode) {
        ArrayList<RouteArc> result = new ArrayList<RouteArc>();
        for (RouteArc a : this.arcs) {
            if (!a.isDirect() || a.getDest() != otherNode) continue;
            result.add(a);
        }
        return result;
    }

    public int getVisitID() {
        return this.visitId;
    }

    public void visitNet(int visitId, List<RouteNode> visited) {
        if (this.visitId != visitId) {
            ArrayDeque<RouteNode> toVisit = new ArrayDeque<RouteNode>();
            toVisit.add(this);
            while (!toVisit.isEmpty()) {
                RouteNode n = (RouteNode)toVisit.pop();
                if (n.visitId == visitId) continue;
                n.arcs.forEach(a -> toVisit.addLast(a.getDest()));
                visited.add(n);
                n.visitId = visitId;
            }
        }
    }

    public void setUseCompactDirs(boolean newValue) {
        this.useCompactDirs = newValue;
    }

    public boolean getUseCompactDirs() {
        return this.useCompactDirs;
    }

    public void setRoadClass(int roadClass) {
        this.nodeClass = (byte)roadClass;
    }

    public static boolean isWarningLogged() {
        return log.isLoggable(Level.WARNING);
    }
}

