/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr10Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr11Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrMapSection;
import uk.me.parabola.imgfmt.app.mdr.MdrUtils;

public class Mdr10
extends MdrMapSection {
    private static final int MAX_GROUP_NUMBER = 13;
    private List<List<Mdr10Record>> poiTypes = new ArrayList<List<Mdr10Record>>();
    private int numberOfPois;

    public Mdr10(MdrConfig config) {
        this.setConfig(config);
        while (this.poiTypes.size() <= 13) {
            this.poiTypes.add(new ArrayList());
        }
    }

    public void addPoiType(Mdr11Record poi) {
        Mdr10Record t = new Mdr10Record();
        int fullType = poi.getType();
        int group = MdrUtils.getGroupForPoi(fullType);
        if (group == 0) {
            return;
        }
        if (group == 1) {
            t.setSubtype(MdrUtils.getTypeFromFullType(fullType));
        } else {
            t.setSubtype(MdrUtils.getSubtypeFromFullType(fullType));
        }
        t.setMdr11ref(poi);
        this.poiTypes.get(group).add(t);
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int count = 0;
        for (List<Mdr10Record> poiGroup : this.poiTypes) {
            if (poiGroup == null) continue;
            poiGroup.sort(null);
            String lastName = null;
            int lastSub = -1;
            for (Mdr10Record t : poiGroup) {
                Mdr11Record mdr11ref = t.getMdr11ref();
                this.addIndexPointer(mdr11ref.getMapIndex(), ++count);
                writer.put1u(t.getSubtype());
                int offset = mdr11ref.getRecordNumber();
                String name = mdr11ref.getName();
                boolean isNew = !name.equals(lastName) || t.getSubtype() != lastSub;
                this.putPoiIndex(writer, offset, isNew);
                lastName = name;
                lastSub = t.getSubtype();
            }
        }
    }

    public Map<Integer, Integer> getGroupSizes() {
        LinkedHashMap<Integer, Integer> m = new LinkedHashMap<Integer, Integer>();
        for (int group = 1; group <= 13; ++group) {
            int size = this.poiTypes.get(group).size();
            if (size <= 0) continue;
            m.put(group, size);
        }
        return m;
    }

    @Override
    public int getItemSize() {
        return 0;
    }

    @Override
    protected int numberOfItems() {
        return this.numberOfPois;
    }

    public void setNumberOfPois(int numberOfPois) {
        this.numberOfPois = numberOfPois;
    }

    @Override
    protected void releaseMemory() {
        this.poiTypes = null;
    }

    @Override
    public int getExtraValue() {
        return 0;
    }
}

