/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.mdr.NamedRecord;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public abstract class LargeListSorter<T extends NamedRecord> {
    private final Sort sort;

    public LargeListSorter(Sort sort) {
        this.sort = sort;
    }

    public void sort(List<T> list) {
        this.mergeSort(0, list, 0, list.size());
    }

    private void mergeSort(int depth, List<T> list, int start, int len) {
        if (len > 1000000 && depth < 3) {
            this.mergeSort(depth + 1, list, start, len / 2);
            this.mergeSort(depth + 1, list, start + len / 2, len - len / 2);
            this.merge(list, start, len);
        } else {
            int i;
            HashMap<String, byte[]> cache = new HashMap<String, byte[]>();
            ArrayList<SortKey<NamedRecord>> keys = new ArrayList<SortKey<NamedRecord>>(len);
            for (i = start; i < start + len; ++i) {
                keys.add(this.makeKey((NamedRecord)list.get(i), this.sort, cache));
            }
            cache = null;
            keys.sort(null);
            for (i = 0; i < keys.size(); ++i) {
                SortKey sk = (SortKey)keys.get(i);
                NamedRecord r = (NamedRecord)sk.getObject();
                list.set(start + i, r);
            }
        }
    }

    private void merge(List<T> list, int start, int len) {
        int pos1 = start;
        int pos2 = start + len / 2;
        int stop1 = start + len / 2;
        int stop2 = start + len;
        boolean fetch1 = true;
        boolean fetch2 = true;
        ArrayList<NamedRecord> merged = new ArrayList<NamedRecord>();
        SortKey<NamedRecord> sk1 = null;
        SortKey<NamedRecord> sk2 = null;
        while (pos1 < stop1 && pos2 < stop2) {
            int d;
            if (fetch1) {
                sk1 = this.makeKey((NamedRecord)list.get(pos1), this.sort, null);
                fetch1 = false;
            }
            if (fetch2) {
                sk2 = this.makeKey((NamedRecord)list.get(pos2), this.sort, null);
                fetch2 = false;
            }
            if ((d = sk1.compareTo((NamedRecord)((Object)sk2))) <= 0) {
                merged.add(sk1.getObject());
                fetch1 = true;
                ++pos1;
                continue;
            }
            merged.add((NamedRecord)sk2.getObject());
            fetch2 = true;
            ++pos2;
        }
        while (pos1 < stop1) {
            merged.add((NamedRecord)list.get(pos1++));
        }
        while (pos2 < stop2) {
            merged.add((NamedRecord)list.get(pos2++));
        }
        assert (merged.size() == len);
        for (int i = 0; i < len; ++i) {
            list.set(start + i, merged.get(i));
        }
    }

    protected abstract SortKey<T> makeKey(T var1, Sort var2, Map<String, byte[]> var3);
}

