/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import java.io.IOException;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.SectionWriter;

public class Section {
    private int itemSize;
    private int size;
    private int position;
    private Section link;
    private int extraValue;

    public Section() {
    }

    public Section(int itemSize) {
        this.itemSize = itemSize;
    }

    public Section(Section link, int itemSize) {
        this.itemSize = itemSize;
        this.link = link;
    }

    public Section(Section link) {
        this.link = link;
    }

    public void inc() {
        this.size += this.itemSize;
    }

    public int getItemSize() {
        return this.itemSize;
    }

    public void setItemSize(int itemSize) {
        this.itemSize = itemSize;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getPosition() {
        if (this.link != null) {
            return this.link.getEndPos();
        }
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
        this.link = null;
    }

    public int getEndPos() {
        return this.getPosition() + this.size;
    }

    public String toString() {
        return "pos=" + this.getPosition() + ", size=" + this.size + ", itemSize=" + this.itemSize;
    }

    public int getNumItems() {
        if (this.itemSize == 0) {
            return 0;
        }
        return this.size / this.itemSize;
    }

    public int getExtraValue() {
        return this.extraValue;
    }

    public void setExtraValue(int extraValue) {
        this.extraValue = extraValue;
    }

    public void readSectionInfo(ImgFileReader reader, boolean withItemSize) {
        this.readSectionInfo(reader, withItemSize, false);
    }

    public void readSectionInfo(ImgFileReader reader, boolean withItemSize, boolean withExtraValue) {
        this.setPosition(reader.get4());
        this.setSize(reader.get4());
        if (withItemSize) {
            this.setItemSize(reader.get2u());
        }
        if (withExtraValue) {
            this.setExtraValue(reader.get4());
        }
    }

    public SectionWriter makeSectionWriter(ImgFileWriter writer) {
        this.setPosition(writer.position());
        return new SectionWriter(writer, this);
    }

    public void writeSectionInfo(ImgFileWriter writer) {
        this.writeSectionInfo(writer, false);
    }

    public void writeSectionInfo(ImgFileWriter writer, boolean withItemSize) {
        this.writeSectionInfo(writer, withItemSize, false);
    }

    public void writeSectionInfo(ImgFileWriter writer, boolean withItemSize, boolean withExtraValue) {
        writer.put4(this.getPosition());
        writer.put4(this.getSize());
        if (withItemSize || this.getItemSize() > 0) {
            writer.put2u(this.getItemSize());
        }
        if (withExtraValue) {
            writer.put4(this.getExtraValue());
        }
    }

    public static void close(ImgFileWriter writer) {
        assert (writer instanceof SectionWriter);
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

