/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.value;

import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import org.reactfx.Subscription;
import org.reactfx.value.Val;
import org.reactfx.value.ValBase;

abstract class FlatMapped<T, U, O extends ObservableValue<U>>
extends ValBase<U> {
    final Val<O> src;
    private Subscription selectedSubscription = null;

    public FlatMapped(ObservableValue<T> src, Function<? super T, O> f2) {
        this.src = Val.map(src, f2);
    }

    @Override
    protected final Subscription connect() {
        return Val.observeInvalidations(this.src, obs -> this.srcInvalidated()).and(this::stopObservingSelected);
    }

    @Override
    protected final U computeValue() {
        if (this.isObservingInputs()) {
            this.startObservingSelected();
        }
        return this.src.getOpt().map(ObservableValue::getValue).orElse(null);
    }

    private void startObservingSelected() {
        assert (this.isObservingInputs());
        if (this.selectedSubscription == null) {
            this.src.ifPresent(sel -> {
                this.selectedSubscription = Val.observeInvalidations(sel, obs -> this.selectedInvalidated());
            });
        }
    }

    private void stopObservingSelected() {
        if (this.selectedSubscription != null) {
            this.selectedSubscription.unsubscribe();
            this.selectedSubscription = null;
        }
    }

    private void selectedInvalidated() {
        this.invalidate();
    }

    private void srcInvalidated() {
        this.stopObservingSelected();
        this.invalidate();
    }
}

