/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.value;

import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.reactfx.util.WrapperBase;

class ChangeListenerWrapper<T>
extends WrapperBase<ChangeListener<? super T>>
implements Consumer<T> {
    private final ObservableValue<T> obs;

    public ChangeListenerWrapper(ObservableValue<T> obs, ChangeListener<? super T> listener) {
        super(listener);
        this.obs = obs;
    }

    @Override
    public void accept(T oldValue) {
        Object newValue = this.obs.getValue();
        if (!Objects.equals(oldValue, newValue)) {
            ((ChangeListener)this.getWrappedValue()).changed(this.obs, oldValue, newValue);
        }
    }
}

