/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.value;

import java.util.function.BiFunction;
import javafx.animation.Transition;
import javafx.beans.value.ObservableValue;
import javafx.util.Duration;
import org.reactfx.Subscription;
import org.reactfx.util.Interpolator;
import org.reactfx.value.Val;
import org.reactfx.value.ValBase;

class AnimatedVal<T>
extends ValBase<T> {
    private final ObservableValue<T> src;
    private final BiFunction<? super T, ? super T, java.time.Duration> duration;
    private final Interpolator<T> interpolator;
    private final FractionTransition transition = new FractionTransition();
    private double fraction = 1.0;
    private T oldValue = null;

    AnimatedVal(ObservableValue<T> src, BiFunction<? super T, ? super T, java.time.Duration> duration, Interpolator<T> interpolator) {
        this.src = src;
        this.duration = duration;
        this.interpolator = interpolator;
    }

    @Override
    protected Subscription connect() {
        this.oldValue = this.src.getValue();
        return Val.observeChanges(this.src, (obs, oldVal, newVal) -> {
            this.oldValue = this.getValue();
            java.time.Duration d2 = this.duration.apply(this.oldValue, newVal);
            this.transition.setDuration(d2);
            this.transition.playFromStart();
        });
    }

    @Override
    protected T computeValue() {
        return (T)(this.fraction == 1.0 ? this.src.getValue() : this.interpolator.interpolate(this.oldValue, this.src.getValue(), this.fraction));
    }

    private final class FractionTransition
    extends Transition {
        private FractionTransition() {
        }

        protected void interpolate(double frac) {
            AnimatedVal.this.fraction = frac;
            AnimatedVal.this.invalidate();
        }

        void setDuration(java.time.Duration d2) {
            this.setCycleDuration(Duration.millis((double)d2.toMillis()));
        }
    }
}

