/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Function;
import org.reactfx.util.ConcatView;
import org.reactfx.util.ListConcatenation;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;

public final class Lists {
    private Lists() {
    }

    public static <E> int hashCode(List<E> list) {
        int hashCode = 1;
        for (E e2 : list) {
            hashCode = 31 * hashCode + Objects.hashCode(e2);
        }
        return hashCode;
    }

    public static boolean equals(List<?> list, Object o2) {
        if (o2 == list) {
            return true;
        }
        if (!(o2 instanceof List)) {
            return false;
        }
        List that = (List)o2;
        if (list.size() != that.size()) {
            return false;
        }
        Iterator<?> it1 = list.iterator();
        Iterator it2 = that.iterator();
        while (it1.hasNext()) {
            if (Objects.equals(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    public static String toString(List<?> list) {
        StringBuilder res = new StringBuilder();
        res.append('[');
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            res.append(it.next());
            if (!it.hasNext()) continue;
            res.append(", ");
        }
        res.append(']');
        return res.toString();
    }

    public static <E> Iterator<E> readOnlyIterator(final Collection<? extends E> col) {
        return new Iterator<E>(){
            private final Iterator<? extends E> delegate;
            {
                this.delegate = col.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public E next() {
                return this.delegate.next();
            }
        };
    }

    public static boolean isValidIndex(int index, int size) {
        return Lists.isValidIndex(0, index, size);
    }

    public static boolean isValidIndex(int min, int index, int max) {
        return min <= index && index < max;
    }

    public static void checkIndex(int index, int size) {
        Lists.checkIndex(0, index, size);
    }

    public static void checkIndex(int min, int index, int max) {
        if (!Lists.isValidIndex(min, index, max)) {
            throw new IndexOutOfBoundsException(index + " not in [" + min + ", " + max + ")");
        }
    }

    public static boolean isValidPosition(int position, int size) {
        return Lists.isValidPosition(0, position, size);
    }

    public static boolean isValidPosition(int min, int position, int max) {
        return min <= position && position <= max;
    }

    public static void checkPosition(int position, int size) {
        Lists.checkPosition(0, position, size);
    }

    public static void checkPosition(int min, int position, int max) {
        if (!Lists.isValidPosition(min, position, max)) {
            throw new IndexOutOfBoundsException(position + " not in [" + min + ", " + max + "]");
        }
    }

    public static boolean isValidRange(int from, int to, int size) {
        return Lists.isValidRange(0, from, to, size);
    }

    public static boolean isValidRange(int min, int from, int to, int max) {
        return min <= from && from <= to && to <= max;
    }

    public static void checkRange(int from, int to, int size) {
        Lists.checkRange(0, from, to, size);
    }

    public static void checkRange(int min, int from, int to, int max) {
        if (!Lists.isValidRange(min, from, to, max)) {
            throw new IndexOutOfBoundsException("[" + from + ", " + to + ") is not a valid range within [" + min + ", " + max + ")");
        }
    }

    public static boolean isNonEmptyRange(int from, int to, int size) {
        return Lists.isNonEmptyRange(0, from, to, size);
    }

    public static boolean isNonEmptyRange(int min, int from, int to, int max) {
        return min <= from && from < to && to <= max;
    }

    public static boolean isProperRange(int from, int to, int size) {
        return Lists.isProperRange(0, from, to, size);
    }

    public static boolean isProperRange(int min, int from, int to, int max) {
        return Lists.isValidRange(min, from, to, max) && (min < from || to < max);
    }

    public static boolean isProperNonEmptyRange(int from, int to, int size) {
        return Lists.isProperNonEmptyRange(0, from, to, size);
    }

    public static boolean isProperNonEmptyRange(int min, int from, int to, int max) {
        return Lists.isNonEmptyRange(min, from, to, max) && (min < from || to < max);
    }

    public static boolean isStrictlyInsideRange(int from, int to, int size) {
        return Lists.isStrictlyInsideRange(0, from, to, size);
    }

    public static boolean isStrictlyInsideRange(int min, int from, int to, int max) {
        return min < from && from <= to && to < max;
    }

    public static boolean isStrictlyInsideNonEmptyRange(int from, int to, int size) {
        return Lists.isStrictlyInsideNonEmptyRange(0, from, to, size);
    }

    public static boolean isStrictlyInsideNonEmptyRange(int min, int from, int to, int max) {
        return min < from && from < to && to < max;
    }

    public static <E, F> List<F> mappedView(final List<? extends E> source, final Function<? super E, ? extends F> f2) {
        return new AbstractList<F>(){

            @Override
            public F get(int index) {
                return f2.apply(source.get(index));
            }

            @Override
            public int size() {
                return source.size();
            }
        };
    }

    @SafeVarargs
    public static <E> List<E> concatView(List<? extends E> ... lists) {
        return Lists.concatView(Arrays.asList(lists));
    }

    public static <E> List<E> concatView(List<List<? extends E>> lists) {
        if (lists.isEmpty()) {
            return Collections.emptyList();
        }
        return ConcatView.create(lists);
    }

    @SafeVarargs
    public static <E> List<E> concat(List<? extends E> ... lists) {
        return Lists.concat(Arrays.asList(lists));
    }

    public static <E> List<E> concat(List<List<? extends E>> lists) {
        return ListConcatenation.create(lists);
    }

    public static int commonPrefixLength(List<?> l2, List<?> m2) {
        ListIterator<?> i2 = l2.listIterator();
        ListIterator<?> j2 = m2.listIterator();
        while (i2.hasNext() && j2.hasNext()) {
            if (Objects.equals(i2.next(), j2.next())) continue;
            return i2.nextIndex() - 1;
        }
        return i2.nextIndex();
    }

    public static int commonSuffixLength(List<?> l2, List<?> m2) {
        ListIterator<?> i2 = l2.listIterator(l2.size());
        ListIterator<?> j2 = m2.listIterator(m2.size());
        while (i2.hasPrevious() && j2.hasPrevious()) {
            if (Objects.equals(i2.previous(), j2.previous())) continue;
            return l2.size() - i2.nextIndex() - 1;
        }
        return l2.size() - i2.nextIndex();
    }

    public static Tuple2<Integer, Integer> commonPrefixSuffixLengths(List<?> l1, List<?> l2) {
        int n1 = l1.size();
        int n2 = l2.size();
        if (n1 == 0 || n2 == 0) {
            return Tuples.t(0, 0);
        }
        int pref = Lists.commonPrefixLength(l1, l2);
        if (pref == n1 || pref == n2) {
            return Tuples.t(pref, 0);
        }
        int suff = Lists.commonSuffixLength(l1, l2);
        return Tuples.t(pref, suff);
    }
}

