/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.reactfx.util.Lists;

public abstract class ListHelper<T> {
    public static <T> T get(ListHelper<T> listHelper, int index) {
        Lists.checkIndex(index, ListHelper.size(listHelper));
        return listHelper.get(index);
    }

    public static <T> ListHelper<T> add(ListHelper<T> listHelper, T elem) {
        if (listHelper == null) {
            return new SingleElemHelper<T>(elem);
        }
        return listHelper.add(elem);
    }

    public static <T> ListHelper<T> remove(ListHelper<T> listHelper, T elem) {
        if (listHelper == null) {
            return listHelper;
        }
        return listHelper.remove(elem);
    }

    public static <T> void forEach(ListHelper<T> listHelper, Consumer<? super T> f2) {
        if (listHelper != null) {
            listHelper.forEach(f2);
        }
    }

    public static <T> void forEachBetween(ListHelper<T> listHelper, int from, int to, Consumer<? super T> f2) {
        Lists.checkRange(from, to, ListHelper.size(listHelper));
        if (from < to) {
            listHelper.forEachBetween(from, to, f2);
        }
    }

    public static <T> Iterator<T> iterator(ListHelper<T> listHelper) {
        if (listHelper != null) {
            return listHelper.iterator();
        }
        return Collections.emptyIterator();
    }

    public static <T> Iterator<T> iterator(ListHelper<T> listHelper, int from, int to) {
        Lists.checkRange(from, to, ListHelper.size(listHelper));
        if (from < to) {
            return listHelper.iterator(from, to);
        }
        return Collections.emptyIterator();
    }

    public static <T> Optional<T> reduce(ListHelper<T> listHelper, BinaryOperator<T> f2) {
        if (listHelper == null) {
            return Optional.empty();
        }
        return listHelper.reduce(f2);
    }

    public static <T, U> U reduce(ListHelper<T> listHelper, U unit, BiFunction<U, T, U> f2) {
        if (listHelper == null) {
            return unit;
        }
        return listHelper.reduce(unit, f2);
    }

    public static <T> T[] toArray(ListHelper<T> listHelper, IntFunction<T[]> allocator) {
        if (listHelper == null) {
            return allocator.apply(0);
        }
        return listHelper.toArray(allocator);
    }

    public static <T> boolean isEmpty(ListHelper<T> listHelper) {
        return listHelper == null;
    }

    public static <T> int size(ListHelper<T> listHelper) {
        if (listHelper == null) {
            return 0;
        }
        return listHelper.size();
    }

    private ListHelper() {
    }

    abstract T get(int var1);

    abstract ListHelper<T> add(T var1);

    abstract ListHelper<T> remove(T var1);

    abstract void forEach(Consumer<? super T> var1);

    abstract void forEachBetween(int var1, int var2, Consumer<? super T> var3);

    abstract Iterator<T> iterator();

    abstract Iterator<T> iterator(int var1, int var2);

    abstract Optional<T> reduce(BinaryOperator<T> var1);

    abstract <U> U reduce(U var1, BiFunction<U, T, U> var2);

    abstract T[] toArray(IntFunction<T[]> var1);

    abstract int size();

    private static class MultiElemHelper<T>
    extends ListHelper<T> {
        private final List<T> elems;
        private int iterating = 0;

        @SafeVarargs
        MultiElemHelper(T ... elems) {
            this(Arrays.asList(elems));
        }

        private MultiElemHelper(List<T> elems) {
            this.elems = new ArrayList<T>(elems);
        }

        private MultiElemHelper<T> copy() {
            return new MultiElemHelper<T>(this.elems);
        }

        @Override
        T get(int index) {
            return this.elems.get(index);
        }

        @Override
        ListHelper<T> add(T elem) {
            if (this.iterating > 0) {
                return this.copy().add(elem);
            }
            this.elems.add(elem);
            return this;
        }

        @Override
        ListHelper<T> remove(T elem) {
            int idx = this.elems.indexOf(elem);
            if (idx == -1) {
                return this;
            }
            switch (this.elems.size()) {
                case 0: 
                case 1: {
                    throw new AssertionError();
                }
                case 2: {
                    return new SingleElemHelper<T>(this.elems.get(1 - idx));
                }
            }
            if (this.iterating > 0) {
                return this.copy().remove(elem);
            }
            this.elems.remove(elem);
            return this;
        }

        @Override
        void forEach(Consumer<? super T> f2) {
            ++this.iterating;
            try {
                this.elems.forEach(f2);
            }
            finally {
                --this.iterating;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void forEachBetween(int from, int to, Consumer<? super T> f2) {
            ++this.iterating;
            try {
                this.elems.subList(from, to).forEach(f2);
            }
            finally {
                --this.iterating;
            }
        }

        @Override
        Iterator<T> iterator() {
            return this.iterator(0, this.elems.size());
        }

        @Override
        Iterator<T> iterator(final int from, final int to) {
            assert (from < to);
            ++this.iterating;
            return new Iterator<T>(){
                int next;
                {
                    this.next = from;
                }

                @Override
                public boolean hasNext() {
                    return this.next < to;
                }

                @Override
                public T next() {
                    if (this.next < to) {
                        Object res = elems.get(this.next);
                        ++this.next;
                        if (this.next == to) {
                            --iterating;
                        }
                        return res;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        Optional<T> reduce(BinaryOperator<T> f2) {
            return this.elems.stream().reduce(f2);
        }

        @Override
        <U> U reduce(U unit, BiFunction<U, T, U> f2) {
            U u2 = unit;
            for (T elem : this.elems) {
                u2 = f2.apply(u2, elem);
            }
            return u2;
        }

        @Override
        T[] toArray(IntFunction<T[]> allocator) {
            return this.elems.toArray(allocator.apply(this.size()));
        }

        @Override
        int size() {
            return this.elems.size();
        }
    }

    private static class SingleElemHelper<T>
    extends ListHelper<T> {
        private final T elem;

        SingleElemHelper(T elem) {
            this.elem = elem;
        }

        @Override
        T get(int index) {
            assert (index == 0);
            return this.elem;
        }

        @Override
        ListHelper<T> add(T elem) {
            return new MultiElemHelper<Object>(this.elem, elem);
        }

        @Override
        ListHelper<T> remove(T elem) {
            if (Objects.equals(this.elem, elem)) {
                return null;
            }
            return this;
        }

        @Override
        void forEach(Consumer<? super T> f2) {
            f2.accept(this.elem);
        }

        @Override
        void forEachBetween(int from, int to, Consumer<? super T> f2) {
            assert (from == 0 && to == 1);
            f2.accept(this.elem);
        }

        @Override
        Iterator<T> iterator() {
            return new Iterator<T>(){
                boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public T next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return elem;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        Iterator<T> iterator(int from, int to) {
            assert (from == 0 && to == 1);
            return this.iterator();
        }

        @Override
        Optional<T> reduce(BinaryOperator<T> f2) {
            return Optional.of(this.elem);
        }

        @Override
        <U> U reduce(U unit, BiFunction<U, T, U> f2) {
            return f2.apply(unit, this.elem);
        }

        @Override
        T[] toArray(IntFunction<T[]> allocator) {
            T[] res = allocator.apply(1);
            res[0] = this.elem;
            return res;
        }

        @Override
        int size() {
            return 1;
        }
    }
}

