/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.reactfx.util.HexaFunction;
import org.reactfx.util.PentaFunction;
import org.reactfx.util.TetraFunction;
import org.reactfx.util.TriFunction;

public abstract class LL<T>
implements Iterable<T> {
    public static <T> LL<T> nil() {
        return Nil.instance();
    }

    public static <T> Cons<T> cons(T head, LL<? extends T> tail) {
        return new Cons(head, tail);
    }

    @SafeVarargs
    public static <T> Cons<T> of(T head, T ... tail) {
        return LL.cons(head, LL.of(tail, tail.length, LL.nil()));
    }

    private static <T> LL<T> of(T[] elems, int to, LL<T> tail) {
        if (to == 0) {
            return tail;
        }
        return LL.of(elems, to - 1, LL.cons(elems[to - 1], tail));
    }

    public static <T> LL<? extends T> concat(LL<? extends T> l1, LL<? extends T> l2) {
        if (l1.isEmpty()) {
            return l2;
        }
        return LL.cons(l1.head(), LL.concat(l1.tail(), l2));
    }

    private LL() {
    }

    public abstract boolean isEmpty();

    public abstract int size();

    public abstract T head();

    public abstract LL<? extends T> tail();

    public abstract <U> LL<U> map(Function<? super T, ? extends U> var1);

    public abstract <R> R fold(R var1, BiFunction<? super R, ? super T, ? extends R> var2);

    public abstract <R> Optional<R> mapReduce(Function<? super T, ? extends R> var1, BinaryOperator<R> var2);

    public boolean all(Predicate<T> cond) {
        return this.fold(true, (b2, t2) -> b2 != false && cond.test(t2));
    }

    public <U> U mapFirst2(BiFunction<? super T, ? super T, ? extends U> f2) {
        return f2.apply(this.head(), this.tail().head());
    }

    public <U> U mapFirst3(TriFunction<? super T, ? super T, ? super T, ? extends U> f2) {
        return this.tail().mapFirst2(f2.pApply(this.head()));
    }

    public <U> U mapFirst4(TetraFunction<? super T, ? super T, ? super T, ? super T, ? extends U> f2) {
        return this.tail().mapFirst3(f2.pApply(this.head()));
    }

    public <U> U mapFirst5(PentaFunction<? super T, ? super T, ? super T, ? super T, ? super T, ? extends U> f2) {
        return this.tail().mapFirst4(f2.pApply(this.head()));
    }

    public <U> U mapFirst6(HexaFunction<? super T, ? super T, ? super T, ? super T, ? super T, ? super T, ? extends U> f2) {
        return this.tail().mapFirst5(f2.pApply(this.head()));
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.head());
        LL<T> tail = this.tail();
        while (!tail.isEmpty()) {
            sb.append(",").append(tail.head());
            tail = tail.tail();
        }
        sb.append("]");
        return sb.toString();
    }

    public Stream<T> stream() {
        Spliterator spliterator = new Spliterator<T>(){
            private final Iterator<T> iterator;
            {
                this.iterator = LL.this.iterator();
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (this.iterator.hasNext()) {
                    action.accept(this.iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<T> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return LL.this.size();
            }

            @Override
            public int characteristics() {
                return 1088;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public static final class Cons<T>
    extends LL<T> {
        private final T head;
        private final LL<? extends T> tail;
        private final int size;

        private Cons(T head, LL<? extends T> tail) {
            this.head = head;
            this.tail = tail;
            this.size = 1 + tail.size();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public T head() {
            return this.head;
        }

        @Override
        public LL<? extends T> tail() {
            return this.tail;
        }

        @Override
        public <U> Cons<U> map(Function<? super T, ? extends U> f2) {
            return Cons.cons(f2.apply(this.head), this.tail.map(f2));
        }

        @Override
        public <R> R fold(R acc, BiFunction<? super R, ? super T, ? extends R> reduction) {
            return this.tail.fold(reduction.apply(acc, this.head), reduction);
        }

        @Override
        public final Iterator<T> iterator() {
            return new Iterator<T>(){
                private LL<? extends T> l;
                {
                    this.l = this;
                }

                @Override
                public boolean hasNext() {
                    return !this.l.isEmpty();
                }

                @Override
                public T next() {
                    Object res = this.l.head();
                    this.l = this.l.tail();
                    return res;
                }
            };
        }

        @Override
        public <R> Optional<R> mapReduce(Function<? super T, ? extends R> map, BinaryOperator<R> reduce) {
            return Optional.of(this.mapReduce1(map, reduce));
        }

        public <R> R mapReduce1(Function<? super T, ? extends R> map, BinaryOperator<R> reduce) {
            R acc = map.apply(this.head);
            return (R)this.tail.fold(acc, (r2, t2) -> reduce.apply(r2, map.apply(t2)));
        }
    }

    private static class Nil<T>
    extends LL<T> {
        private static final Nil<?> INSTANCE = new Nil();

        private Nil() {
        }

        static <T> Nil<T> instance() {
            return INSTANCE;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public T head() {
            throw new NoSuchElementException();
        }

        @Override
        public LL<T> tail() {
            throw new NoSuchElementException();
        }

        @Override
        public <U> LL<U> map(Function<? super T, ? extends U> f2) {
            return Nil.instance();
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public <R> R fold(R acc, BiFunction<? super R, ? super T, ? extends R> reduction) {
            return acc;
        }

        @Override
        public <R> Optional<R> mapReduce(Function<? super T, ? extends R> map, BinaryOperator<R> reduce) {
            return Optional.empty();
        }
    }
}

