/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javafx.collections.ObservableList;
import org.reactfx.SuspendableBase;
import org.reactfx.collection.ListModificationSequence;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.ProperLiveList;
import org.reactfx.collection.QuasiListChange;
import org.reactfx.collection.SuspendableList;
import org.reactfx.util.AccumulatorSize;
import org.reactfx.util.NotificationAccumulator;

final class SuspendableListWrapper<E>
extends SuspendableBase<LiveList.Observer<? super E, ?>, QuasiListChange<? extends E>, ListModificationSequence<E>>
implements SuspendableList<E>,
ProperLiveList<E> {
    private final ObservableList<E> delegate;

    SuspendableListWrapper(ObservableList<E> source) {
        super(LiveList.quasiChangesOf(source), NotificationAccumulator.listNotifications());
        this.delegate = source;
    }

    @Override
    protected AccumulatorSize sizeOf(ListModificationSequence<E> accum) {
        return AccumulatorSize.ONE;
    }

    @Override
    protected QuasiListChange<? extends E> headOf(ListModificationSequence<E> accum) {
        return accum.asListChange();
    }

    @Override
    protected ListModificationSequence<E> tailOf(ListModificationSequence<E> accum) {
        throw new NoSuchElementException();
    }

    @SafeVarargs
    public final boolean addAll(E ... elements) {
        return this.delegate.addAll((Object[])elements);
    }

    public void remove(int from, int to) {
        this.delegate.remove(from, to);
    }

    @SafeVarargs
    public final boolean removeAll(E ... elements) {
        return this.delegate.removeAll((Object[])elements);
    }

    @SafeVarargs
    public final boolean retainAll(E ... elements) {
        return this.delegate.retainAll((Object[])elements);
    }

    @SafeVarargs
    public final boolean setAll(E ... elements) {
        return this.delegate.setAll((Object[])elements);
    }

    public boolean setAll(Collection<? extends E> c2) {
        return this.delegate.setAll(c2);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean contains(Object o2) {
        return this.delegate.contains(o2);
    }

    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public <T> T[] toArray(T[] a2) {
        return this.delegate.toArray((Object[])a2);
    }

    public boolean add(E e2) {
        return this.delegate.add(e2);
    }

    public boolean remove(Object o2) {
        return this.delegate.remove(o2);
    }

    public boolean containsAll(Collection<?> c2) {
        return this.delegate.containsAll(c2);
    }

    public boolean addAll(Collection<? extends E> c2) {
        return this.delegate.addAll(c2);
    }

    public boolean addAll(int index, Collection<? extends E> c2) {
        return this.delegate.addAll(index, c2);
    }

    public boolean removeAll(Collection<?> c2) {
        return this.delegate.removeAll(c2);
    }

    public boolean retainAll(Collection<?> c2) {
        return this.delegate.retainAll(c2);
    }

    public void clear() {
        this.delegate.clear();
    }

    public E get(int index) {
        return (E)this.delegate.get(index);
    }

    public E set(int index, E element) {
        return (E)this.delegate.set(index, element);
    }

    public void add(int index, E element) {
        this.delegate.add(index, element);
    }

    public E remove(int index) {
        return (E)this.delegate.remove(index);
    }

    public int indexOf(Object o2) {
        return this.delegate.indexOf(o2);
    }

    public int lastIndexOf(Object o2) {
        return this.delegate.lastIndexOf(o2);
    }

    public ListIterator<E> listIterator() {
        return this.delegate.listIterator();
    }

    public ListIterator<E> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    public List<E> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }
}

