/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.List;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.scene.control.IndexRange;
import org.reactfx.Subscription;
import org.reactfx.collection.ListChangeAccumulator;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.LiveListBase;
import org.reactfx.collection.MemoizationList;
import org.reactfx.collection.ProperLiveList;
import org.reactfx.collection.QuasiListChange;
import org.reactfx.collection.QuasiListModification;
import org.reactfx.collection.QuasiListModificationImpl;
import org.reactfx.collection.UnmodifiableByDefaultLiveList;
import org.reactfx.util.Lists;
import org.reactfx.util.SparseList;

class MemoizationListImpl<E>
extends LiveListBase<E>
implements MemoizationList<E>,
UnmodifiableByDefaultLiveList<E> {
    private final SparseList<E> sparseList = new SparseList();
    private final MemoizedView memoizedItems = new MemoizedView();
    private final ObservableList<E> source;

    MemoizationListImpl(ObservableList<E> source) {
        this.source = source;
    }

    @Override
    protected Subscription observeInputs() {
        this.sparseList.insertVoid(0, this.source.size());
        return LiveList.observeQuasiChanges(this.source, this::sourceChanged).and(this.sparseList::clear);
    }

    private void sourceChanged(QuasiListChange<? extends E> qc) {
        ListChangeAccumulator<E> acc = new ListChangeAccumulator<E>();
        for (QuasiListModification quasiListModification : qc) {
            int from = quasiListModification.getFrom();
            int removedSize = quasiListModification.getRemovedSize();
            int memoFrom = this.sparseList.getPresentCountBefore(from);
            List<E> memoRemoved = this.sparseList.collect(from, from + removedSize);
            this.sparseList.spliceByVoid(from, from + removedSize, quasiListModification.getAddedSize());
            acc.add(new QuasiListModificationImpl<E>(memoFrom, memoRemoved, 0));
        }
        this.memoizedItems.prepareNotifications(acc.fetch());
        this.notifyObservers(qc);
        this.memoizedItems.publishNotifications();
    }

    @Override
    public E get(int index) {
        if (!this.isObservingInputs()) {
            return (E)this.source.get(index);
        }
        if (this.sparseList.isPresent(index)) {
            return this.sparseList.getOrThrow(index);
        }
        Object elem = this.source.get(index);
        if (this.sparseList.setIfAbsent(index, elem)) {
            this.memoizedItems.fireElemInsertion(this.sparseList.getPresentCountBefore(index));
        }
        return (E)elem;
    }

    @Override
    public void force(int from, int to) {
        if (!this.isObservingInputs()) {
            throw new IllegalStateException("Cannot force items when memoization is off. To turn memoization on, you have to be observing this list or its memoizedItems.");
        }
        Lists.checkRange(from, to, this.size());
        for (int i2 = from; i2 < to; ++i2) {
            Object elem;
            if (this.sparseList.isPresent(i2) || !this.sparseList.setIfAbsent(i2, elem = this.source.get(i2))) continue;
            int presentBefore = this.sparseList.getPresentCountBefore(i2);
            this.memoizedItems.prepareNotifications(ProperLiveList.elemInsertion(presentBefore));
        }
        this.memoizedItems.publishNotifications();
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    public LiveList<E> memoizedItems() {
        return this.memoizedItems;
    }

    @Override
    public boolean isMemoized(int index) {
        return this.isObservingInputs() && this.sparseList.isPresent(index);
    }

    @Override
    public Optional<E> getIfMemoized(int index) {
        Lists.checkIndex(index, this.size());
        return this.isObservingInputs() ? this.sparseList.get(index) : Optional.empty();
    }

    @Override
    public int getMemoizedCountBefore(int position) {
        Lists.checkPosition(position, this.size());
        return this.isObservingInputs() ? this.sparseList.getPresentCountBefore(position) : 0;
    }

    @Override
    public int getMemoizedCountAfter(int position) {
        Lists.checkPosition(position, this.size());
        return this.isObservingInputs() ? this.sparseList.getPresentCountAfter(position) : 0;
    }

    @Override
    public int getMemoizedCount() {
        return this.memoizedItems.size();
    }

    @Override
    public void forget(int from, int to) {
        if (!this.isObservingInputs()) {
            throw new IllegalStateException("There is nothing to forget, because memoization is off. To turn memoization on, you have to be observing this list or its memoizedItems.");
        }
        Lists.checkRange(from, to, this.size());
        int memoChangeFrom = this.sparseList.getPresentCountBefore(from);
        List<E> memoRemoved = this.sparseList.collect(from, to);
        this.sparseList.spliceByVoid(from, to, to - from);
        this.memoizedItems.fireRemoveRange(memoChangeFrom, memoRemoved);
    }

    @Override
    public int indexOfMemoizedItem(int index) {
        return this.sparseList.indexOfPresentItem(index);
    }

    @Override
    public IndexRange getMemoizedItemsRange() {
        return this.sparseList.getPresentItemsRange();
    }

    private class MemoizedView
    extends LiveListBase<E>
    implements UnmodifiableByDefaultLiveList<E> {
        private MemoizedView() {
        }

        @Override
        protected Subscription observeInputs() {
            return MemoizationListImpl.this.pin();
        }

        @Override
        public E get(int index) {
            return MemoizationListImpl.this.sparseList.getPresent(index);
        }

        @Override
        public int size() {
            return MemoizationListImpl.this.sparseList.getPresentCount();
        }

        private void prepareNotifications(QuasiListChange<? extends E> change) {
            this.enqueueNotifications(change);
        }

        private void prepareNotifications(QuasiListModification<? extends E> mod) {
            this.enqueueNotifications(mod.asListChange());
        }

        private void publishNotifications() {
            this.notifyObservers();
        }
    }
}

