/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.reactfx.Subscription;
import org.reactfx.collection.ListChangeAccumulator;
import org.reactfx.collection.LiveListBase;
import org.reactfx.collection.ProperLiveList;

public final class LiveArrayList<E>
extends LiveListBase<E> {
    private List<E> list;

    public LiveArrayList() {
        this.list = new ArrayList();
    }

    public LiveArrayList(Collection<? extends E> c2) {
        this.list = new ArrayList<E>(c2);
    }

    @SafeVarargs
    public LiveArrayList(E ... initialElements) {
        this(Arrays.asList(initialElements));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        E replaced = this.list.set(index, element);
        this.fireElemReplacement(index, replaced);
        return replaced;
    }

    public boolean setAll(Collection<? extends E> c2) {
        List<E> removed = this.list;
        this.list = new ArrayList<E>(c2);
        this.fireContentReplacement(removed);
        return true;
    }

    @SafeVarargs
    public final boolean setAll(E ... elems) {
        return this.setAll((Collection<? extends E>)Arrays.asList(elems));
    }

    @Override
    public void add(int index, E element) {
        this.list.add(index, element);
        this.fireElemInsertion(index);
    }

    @Override
    public boolean add(E e2) {
        this.add(this.size(), e2);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c2) {
        this.list.addAll(index, c2);
        this.fireRangeInsertion(index, c2.size());
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c2) {
        return this.addAll(this.size(), c2);
    }

    @SafeVarargs
    public final boolean addAll(E ... elems) {
        return this.addAll((Collection<? extends E>)Arrays.asList(elems));
    }

    @Override
    public E remove(int index) {
        E removed = this.list.remove(index);
        this.fireElemRemoval(index, removed);
        return removed;
    }

    public void remove(int from, int to) {
        List<E> sublist = this.list.subList(from, to);
        ArrayList<E> removed = new ArrayList<E>(sublist);
        sublist.clear();
        this.fireRemoveRange(from, removed);
    }

    @Override
    public boolean remove(Object o2) {
        int i2 = this.list.indexOf(o2);
        if (i2 != -1) {
            this.remove(i2);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        ListChangeAccumulator<E> acc = new ListChangeAccumulator<E>();
        for (Object o2 : c2) {
            int i2 = this.list.indexOf(o2);
            if (i2 == -1) continue;
            E removed = this.list.remove(i2);
            acc.add(ProperLiveList.elemRemoval(i2, removed));
        }
        if (acc.isEmpty()) {
            return false;
        }
        this.notifyObservers(acc.fetch());
        return true;
    }

    @SafeVarargs
    public final boolean removeAll(E ... elems) {
        return this.removeAll((Collection<?>)Arrays.asList(elems));
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        ListChangeAccumulator<E> acc = new ListChangeAccumulator<E>();
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            E elem = this.list.get(i2);
            if (c2.contains(elem)) continue;
            this.list.remove(i2);
            acc.add(ProperLiveList.elemRemoval(i2, elem));
        }
        if (acc.isEmpty()) {
            return false;
        }
        this.notifyObservers(acc.fetch());
        return true;
    }

    @SafeVarargs
    public final boolean retainAll(E ... elems) {
        return this.retainAll((Collection<?>)Arrays.asList(elems));
    }

    @Override
    public void clear() {
        this.setAll(Collections.emptyList());
    }

    @Override
    protected Subscription observeInputs() {
        return Subscription.EMPTY;
    }
}

