/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class ListIteratorImpl<E>
implements ListIterator<E> {
    private final List<E> list;
    private int position;

    public ListIteratorImpl(List<E> list, int initialPosition) {
        this.list = list;
        this.position = initialPosition;
    }

    public ListIteratorImpl(List<E> list) {
        this(list, 0);
    }

    @Override
    public boolean hasNext() {
        return this.position < this.list.size();
    }

    @Override
    public E next() {
        if (this.position < this.list.size()) {
            return this.list.get(this.position++);
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasPrevious() {
        return this.position > 0;
    }

    @Override
    public E previous() {
        if (this.position > 0) {
            return this.list.get(--this.position);
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.position;
    }

    @Override
    public int previousIndex() {
        return this.position - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E e2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(E e2) {
        throw new UnsupportedOperationException();
    }
}

