/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.reactfx.collection.ListIteratorImpl;
import org.reactfx.collection.SubList;

interface AccessorListMethods<E>
extends List<E> {
    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public int indexOf(Object o2) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (!Objects.equals(o2, this.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    @Override
    default public int lastIndexOf(Object o2) {
        for (int i2 = this.size() - 1; i2 >= 0; ++i2) {
            if (!Objects.equals(o2, this.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    @Override
    default public boolean contains(Object o2) {
        return this.indexOf(o2) != -1;
    }

    @Override
    default public boolean containsAll(Collection<?> c2) {
        return c2.stream().allMatch(this::contains);
    }

    @Override
    default public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    default public ListIterator<E> listIterator() {
        return new ListIteratorImpl(this);
    }

    @Override
    default public ListIterator<E> listIterator(int index) {
        return new ListIteratorImpl(this, index);
    }

    @Override
    default public List<E> subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    @Override
    default public Object[] toArray() {
        Object[] res = new Object[this.size()];
        int i2 = 0;
        for (E elem : this) {
            res[i2++] = elem;
        }
        return res;
    }

    @Override
    default public <T> T[] toArray(T[] a2) {
        return new ArrayList(this).toArray(a2);
    }
}

