/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;

class ThreadBridge<T>
extends EventStreamBase<T> {
    private final EventStream<T> input;
    private final Executor sourceThreadExecutor;
    private final Executor targetThreadExecutor;

    public ThreadBridge(EventStream<T> input, Executor sourceThreadExecutor, Executor targetThreadExecutor) {
        this.input = input;
        this.sourceThreadExecutor = sourceThreadExecutor;
        this.targetThreadExecutor = targetThreadExecutor;
    }

    @Override
    protected Subscription observeInputs() {
        CompletableFuture subscription = new CompletableFuture();
        this.sourceThreadExecutor.execute(() -> subscription.complete(this.input.subscribe(e2 -> this.targetThreadExecutor.execute(() -> this.emit(e2)))));
        return () -> subscription.thenAcceptAsync(Subscription::unsubscribe, this.sourceThreadExecutor);
    }
}

