/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import org.reactfx.AwaitingEventStream;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;
import org.reactfx.util.Timer;

class ThenAccumulateForStream<T, A>
extends EventStreamBase<T>
implements AwaitingEventStream<T> {
    private final EventStream<T> input;
    private final Function<? super T, ? extends A> initial;
    private final BiFunction<? super A, ? super T, ? extends A> reduction;
    private final Function<? super A, List<T>> deconstruction;
    private final Timer timer;
    private State state = State.READY;
    private A acc = null;
    private BooleanBinding pending = null;

    public ThenAccumulateForStream(EventStream<T> input, Function<? super T, ? extends A> initial, BiFunction<? super A, ? super T, ? extends A> reduction, Function<? super A, List<T>> deconstruction, Function<Runnable, Timer> timerFactory) {
        this.input = input;
        this.initial = initial;
        this.reduction = reduction;
        this.deconstruction = deconstruction;
        this.timer = timerFactory.apply(this::handleTimeout);
    }

    @Override
    public ObservableBooleanValue pendingProperty() {
        if (this.pending == null) {
            this.pending = new BooleanBinding(){

                protected boolean computeValue() {
                    return ThenAccumulateForStream.this.state == State.ACC_HAS_EVENT;
                }
            };
        }
        return this.pending;
    }

    @Override
    public boolean isPending() {
        return this.pending != null ? this.pending.get() : this.state == State.ACC_HAS_EVENT;
    }

    @Override
    protected final Subscription observeInputs() {
        return this.input.subscribe(this::handleEvent);
    }

    private void handleEvent(T t2) {
        switch (this.state) {
            case READY: {
                this.timer.restart();
                this.setState(State.ACC_NO_EVENT);
                this.emit(t2);
                break;
            }
            case ACC_NO_EVENT: {
                this.acc = this.initial.apply(t2);
                this.setState(State.ACC_HAS_EVENT);
                break;
            }
            case ACC_HAS_EVENT: {
                this.acc = this.reduction.apply(this.acc, t2);
            }
        }
    }

    private void handleTimeout() {
        List toEmit;
        switch (this.state) {
            case ACC_HAS_EVENT: {
                toEmit = this.deconstruction.apply(this.acc);
                this.acc = null;
                this.state = State.ACC_NO_EVENT;
                break;
            }
            case ACC_NO_EVENT: {
                toEmit = Collections.emptyList();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (Object t2 : toEmit) {
            this.emit(t2);
        }
        if (this.state == State.ACC_NO_EVENT) {
            this.setState(State.READY);
        } else {
            assert (this.state == State.ACC_HAS_EVENT);
            this.timer.restart();
        }
    }

    private void setState(State state) {
        this.state = state;
        this.invalidatePending();
    }

    private void invalidatePending() {
        if (this.pending != null) {
            this.pending.invalidate();
        }
    }

    private static enum State {
        READY,
        ACC_NO_EVENT,
        ACC_HAS_EVENT;

    }
}

