/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import org.reactfx.BiSuspendable;
import org.reactfx.EventStreams;
import org.reactfx.Guard;
import org.reactfx.MultiSuspendable;
import org.reactfx.Subscription;

public interface Suspendable {
    public Guard suspend();

    default public void suspendWhile(Runnable r2) {
        try (Guard g2 = this.suspend();){
            r2.run();
        }
    }

    default public <U> U suspendWhile(Supplier<U> f2) {
        try (Guard g2 = this.suspend();){
            U u2 = f2.get();
            return u2;
        }
    }

    default public Subscription suspendWhen(final ObservableValue<Boolean> condition) {
        return new Subscription(){
            private Guard suspensionGuard = null;
            private final Subscription sub = EventStreams.valuesOf(condition).subscribe(this::suspendSource).and(this::resumeSource);

            @Override
            public void unsubscribe() {
                this.sub.unsubscribe();
            }

            private void suspendSource(boolean suspend) {
                if (suspend) {
                    this.suspendSource();
                } else {
                    this.resumeSource();
                }
            }

            private void suspendSource() {
                if (this.suspensionGuard == null) {
                    this.suspensionGuard = Suspendable.this.suspend();
                }
            }

            private void resumeSource() {
                if (this.suspensionGuard != null) {
                    Guard toClose = this.suspensionGuard;
                    this.suspensionGuard = null;
                    toClose.close();
                }
            }
        };
    }

    public static Suspendable combine(Suspendable ... suspendables) {
        switch (suspendables.length) {
            case 0: {
                throw new IllegalArgumentException("Must invoke with at least 1 argument");
            }
            case 1: {
                return suspendables[0];
            }
            case 2: {
                return new BiSuspendable(suspendables[0], suspendables[1]);
            }
        }
        return new MultiSuspendable(suspendables);
    }
}

