/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.Collection;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.collections.ObservableSet;
import org.reactfx.BiSubscription;
import org.reactfx.EventStreams;
import org.reactfx.MultiSubscription;

@FunctionalInterface
public interface Subscription {
    public static final Subscription EMPTY;

    public void unsubscribe();

    default public Subscription and(Subscription other) {
        return new BiSubscription(this, other);
    }

    public static Subscription multi(Subscription ... subs) {
        switch (subs.length) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return subs[0];
            }
            case 2: {
                return new BiSubscription(subs[0], subs[1]);
            }
        }
        return new MultiSubscription(subs);
    }

    @SafeVarargs
    public static <T> Subscription multi(Function<? super T, ? extends Subscription> f2, T ... elems) {
        return Subscription.multi((Subscription[])Stream.of(elems).map(f2).toArray(Subscription[]::new));
    }

    public static <T> Subscription multi(Function<? super T, ? extends Subscription> f2, Collection<T> elems) {
        return Subscription.multi((Subscription[])elems.stream().map(f2).toArray(Subscription[]::new));
    }

    public static <T> Subscription dynamic(ObservableSet<T> elems, Function<? super T, ? extends Subscription> f2) {
        HashMap elemSubs = new HashMap();
        elems.forEach(t2 -> {
            Subscription cfr_ignored_0 = (Subscription)elemSubs.put(t2, f2.apply(t2));
        });
        Subscription setSub = EventStreams.changesOf(elems).subscribe(ch -> {
            if (ch.wasRemoved()) {
                Subscription sub = (Subscription)elemSubs.remove(ch.getElementRemoved());
                if (!1.$assertionsDisabled && sub == null) {
                    throw new AssertionError();
                }
                sub.unsubscribe();
            }
            if (ch.wasAdded()) {
                Object elem = ch.getElementAdded();
                if (!1.$assertionsDisabled && elemSubs.containsKey(elem)) {
                    throw new AssertionError();
                }
                elemSubs.put(elem, f2.apply(elem));
            }
        });
        return () -> {
            setSub.unsubscribe();
            elemSubs.forEach((t2, sub) -> sub.unsubscribe());
        };
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        EMPTY = () -> {};
    }
}

