/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.Optional;
import java.util.function.BiFunction;
import org.reactfx.EmissionBuilder;
import org.reactfx.EventStream;
import org.reactfx.ObservableStateBuilderImpl;
import org.reactfx.StateMachine;
import org.reactfx.StatefulStreamBuilderImpl;
import org.reactfx.TransitionBuilder;
import org.reactfx.TransmissionBuilder;
import org.reactfx.util.LL;
import org.reactfx.util.Tuple2;

class ObservableStateBuilderOnImpl<S, I>
implements StateMachine.ObservableStateBuilderOn<S, I> {
    private final S initialState;
    private final LL<TransitionBuilder<S>> transitions;
    private final EventStream<I> input;

    ObservableStateBuilderOnImpl(S initialState, LL<TransitionBuilder<S>> transitions, EventStream<I> input) {
        this.initialState = initialState;
        this.transitions = transitions;
        this.input = input;
    }

    @Override
    public StateMachine.ObservableStateBuilder<S> transition(BiFunction<? super S, ? super I, ? extends S> f2) {
        TransitionBuilder<? extends S> transition = new TransitionBuilder<S>(this.input, f2);
        return new ObservableStateBuilderImpl<S>(this.initialState, LL.cons(transition, this.transitions));
    }

    @Override
    public <O> StateMachine.StatefulStreamBuilder<S, O> emit(BiFunction<? super S, ? super I, Optional<O>> f2) {
        EmissionBuilder<? super S, O> emission = new EmissionBuilder<S, O>(this.input, f2);
        return new StatefulStreamBuilderImpl(this.initialState, this.transitions, LL.cons(emission, LL.nil()), LL.nil());
    }

    @Override
    public <O> StateMachine.StatefulStreamBuilder<S, O> transmit(BiFunction<? super S, ? super I, Tuple2<S, Optional<O>>> f2) {
        TransmissionBuilder<? super S, O> transmission = new TransmissionBuilder<S, O>(this.input, f2);
        return new StatefulStreamBuilderImpl(this.initialState, this.transitions, LL.nil(), LL.cons(transmission, LL.nil()));
    }
}

