/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.function.Consumer;
import org.reactfx.ProperObservable;
import org.reactfx.Subscription;
import org.reactfx.util.ListHelper;
import org.reactfx.util.NotificationAccumulator;

public abstract class ObservableBase<O, T>
implements ProperObservable<O, T> {
    private ListHelper<O> observers = null;
    private Subscription inputSubscription = null;
    private final NotificationAccumulator<O, T, ?> pendingNotifications;

    protected ObservableBase(NotificationAccumulator<O, T, ?> pendingNotificationsImpl) {
        this.pendingNotifications = pendingNotificationsImpl;
    }

    protected ObservableBase() {
        this.pendingNotifications = this.defaultNotificationAccumulator();
    }

    protected abstract Subscription observeInputs();

    public final boolean isObservingInputs() {
        return this.inputSubscription != null;
    }

    protected final int getObserverCount() {
        return ListHelper.size(this.observers);
    }

    @Override
    public final void notifyObservers(T event) {
        this.enqueueNotifications(event);
        this.notifyObservers();
    }

    protected final void enqueueNotifications(T event) {
        this.pendingNotifications.addAll(ListHelper.iterator(this.observers), event);
    }

    protected final void notifyObservers() {
        try {
            while (!this.pendingNotifications.isEmpty()) {
                this.pendingNotifications.takeOne().run();
            }
        }
        finally {
            this.pendingNotifications.clear();
        }
    }

    protected final void forEachObserver(Consumer<O> action) {
        ListHelper.forEach(this.observers, o2 -> action.accept(o2));
    }

    protected void newObserver(O observer) {
    }

    @Override
    public final Subscription observe(O observer) {
        this.addObserver(observer);
        return () -> this.removeObserver(observer);
    }

    @Override
    public final void addObserver(O observer) {
        this.observers = ListHelper.add(this.observers, observer);
        if (ListHelper.size(this.observers) == 1) {
            this.inputSubscription = this.observeInputs();
        }
        this.newObserver(observer);
    }

    @Override
    public final void removeObserver(O observer) {
        this.observers = ListHelper.remove(this.observers, observer);
        if (ListHelper.isEmpty(this.observers) && this.inputSubscription != null) {
            this.inputSubscription.unsubscribe();
            this.inputSubscription = null;
        }
    }

    public int hashCode() {
        return this.defaultHashCode();
    }

    public boolean equals(Object o2) {
        return this.defaultEquals(o2);
    }

    public String toString() {
        return this.defaultToString();
    }
}

