/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;
import org.reactfx.util.Lists;

class LatestNStream<T>
extends EventStreamBase<List<T>> {
    private final EventStream<T> source;
    private final int n;
    private List<T> first = null;
    private List<T> second = null;
    private List<T> concatView = null;

    public LatestNStream(EventStream<T> source, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("n must be positive. Was " + n2);
        }
        this.source = source;
        this.n = n2;
    }

    @Override
    protected Subscription observeInputs() {
        this.first = Collections.emptyList();
        this.second = new ArrayList<T>(this.n);
        this.concatView = Lists.concatView(this.first, this.second);
        return this.source.subscribe(this::onEvent);
    }

    private void onEvent(T event) {
        if (this.second.size() == this.n) {
            this.first = this.second;
            this.second = new ArrayList<T>(this.n);
            this.concatView = Lists.concatView(this.first, this.second);
        }
        this.second.add(event);
        int total = this.concatView.size();
        this.emit(this.concatView.subList(Math.max(0, total - this.n), total));
    }
}

