/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.function.Consumer;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;

class HookStream<T>
extends EventStreamBase<T> {
    private final EventStream<T> source;
    private final Consumer<? super T> sideEffect;
    private boolean sideEffectInProgress = false;

    public HookStream(EventStream<T> source, Consumer<? super T> sideEffect) {
        this.source = source;
        this.sideEffect = sideEffect;
    }

    @Override
    protected Subscription observeInputs() {
        return this.source.subscribe(t2 -> {
            if (this.sideEffectInProgress) {
                throw new IllegalStateException("Side effect is not allowed to cause recursive event emission");
            }
            this.sideEffectInProgress = true;
            try {
                this.sideEffect.accept(t2);
            }
            finally {
                this.sideEffectInProgress = false;
            }
            this.emit(t2);
        });
    }
}

