/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.function.Function;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;

class FlatMapStream<T, U>
extends EventStreamBase<U> {
    private final EventStream<T> source;
    private final Function<? super T, ? extends EventStream<U>> mapper;
    private Subscription mappedSubscription = Subscription.EMPTY;

    public FlatMapStream(EventStream<T> src, Function<? super T, ? extends EventStream<U>> f2) {
        this.source = src;
        this.mapper = f2;
    }

    @Override
    protected Subscription observeInputs() {
        Subscription s2 = this.source.subscribe(t2 -> {
            this.mappedSubscription.unsubscribe();
            this.mappedSubscription = this.mapper.apply(t2).subscribe(this::emit);
        });
        return () -> {
            s2.unsubscribe();
            this.mappedSubscription.unsubscribe();
            this.mappedSubscription = Subscription.EMPTY;
        };
    }
}

