/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.animation.AnimationTimer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.MenuItem;
import javafx.stage.Window;
import org.reactfx.Change;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.RigidObservable;
import org.reactfx.ScheduledExecutorServiceTimer;
import org.reactfx.Subscription;
import org.reactfx.collection.ListModification;
import org.reactfx.collection.LiveList;
import org.reactfx.util.Either;
import org.reactfx.util.FxTimer;
import org.reactfx.util.Timer;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuple3;
import org.reactfx.util.Tuple4;
import org.reactfx.util.Tuple5;
import org.reactfx.util.Tuple6;
import org.reactfx.util.Tuples;

public class EventStreams {
    private static final EventStream<?> NEVER = new Never();

    public static <T> EventStream<T> never() {
        return NEVER;
    }

    public static EventStream<Void> invalidationsOf(final Observable observable) {
        return new EventStreamBase<Void>(){

            @Override
            protected Subscription observeInputs() {
                InvalidationListener listener = obs -> this.emit(null);
                observable.addListener(listener);
                return () -> observable.removeListener(listener);
            }
        };
    }

    public static <O extends Observable> EventStream<O> repeatOnInvalidation(final O observable) {
        return new EventStreamBase<O>(){

            @Override
            protected Subscription observeInputs() {
                InvalidationListener listener = obs -> this.emit(observable);
                observable.addListener(listener);
                return () -> observable.removeListener(listener);
            }

            @Override
            protected void newObserver(Consumer<? super O> subscriber) {
                subscriber.accept(observable);
            }
        };
    }

    public static <T> EventStream<T> valuesOf(final ObservableValue<T> observable) {
        return new EventStreamBase<T>(){

            @Override
            protected Subscription observeInputs() {
                ChangeListener listener = (obs, old, val) -> this.emit(val);
                observable.addListener(listener);
                return () -> observable.removeListener(listener);
            }

            @Override
            protected void newObserver(Consumer<? super T> subscriber) {
                subscriber.accept(observable.getValue());
            }
        };
    }

    public static <T> EventStream<T> nonNullValuesOf(final ObservableValue<T> observable) {
        return new EventStreamBase<T>(){

            @Override
            protected Subscription observeInputs() {
                ChangeListener listener = (obs, old, val) -> {
                    if (val != null) {
                        this.emit(val);
                    }
                };
                observable.addListener(listener);
                return () -> observable.removeListener(listener);
            }

            @Override
            protected void newObserver(Consumer<? super T> subscriber) {
                Object val = observable.getValue();
                if (val != null) {
                    subscriber.accept(val);
                }
            }
        };
    }

    public static <T> EventStream<Change<T>> changesOf(final ObservableValue<T> observable) {
        return new EventStreamBase<Change<T>>(){

            @Override
            protected Subscription observeInputs() {
                ChangeListener listener = (obs, old, val) -> this.emit(new Change<Object>(old, val));
                observable.addListener(listener);
                return () -> observable.removeListener(listener);
            }
        };
    }

    public static <T> EventStream<ListChangeListener.Change<? extends T>> changesOf(final ObservableList<T> list) {
        return new EventStreamBase<ListChangeListener.Change<? extends T>>(){

            @Override
            protected Subscription observeInputs() {
                ListChangeListener listener = c2 -> this.emit(c2);
                list.addListener(listener);
                return () -> list.removeListener(listener);
            }
        };
    }

    public static <T> EventStream<ListModification<? extends T>> simpleChangesOf(final ObservableList<T> list) {
        return new EventStreamBase<ListModification<? extends T>>(){

            @Override
            protected Subscription observeInputs() {
                return LiveList.observeChanges(list, c2 -> {
                    for (ListModification mod : c2) {
                        this.emit(mod);
                    }
                });
            }
        };
    }

    public static <T> EventStream<SetChangeListener.Change<? extends T>> changesOf(final ObservableSet<T> set) {
        return new EventStreamBase<SetChangeListener.Change<? extends T>>(){

            @Override
            protected Subscription observeInputs() {
                SetChangeListener listener = c2 -> this.emit(c2);
                set.addListener(listener);
                return () -> set.removeListener(listener);
            }
        };
    }

    public static <K, V> EventStream<MapChangeListener.Change<? extends K, ? extends V>> changesOf(final ObservableMap<K, V> map) {
        return new EventStreamBase<MapChangeListener.Change<? extends K, ? extends V>>(){

            @Override
            protected Subscription observeInputs() {
                MapChangeListener listener = c2 -> this.emit(c2);
                map.addListener(listener);
                return () -> map.removeListener(listener);
            }
        };
    }

    public static <C extends Collection<?> & Observable> EventStream<Integer> sizeOf(C collection) {
        return EventStreams.create(() -> collection.size(), collection);
    }

    public static EventStream<Integer> sizeOf(ObservableMap<?, ?> map) {
        return EventStreams.create(() -> map.size(), new Observable[]{map});
    }

    private static <T> EventStream<T> create(final Supplier<? extends T> computeValue, final Observable ... dependencies) {
        return new EventStreamBase<T>(){
            private T previousValue;

            @Override
            protected Subscription observeInputs() {
                InvalidationListener listener = arg_0 -> this.lambda$observeInputs$0((Supplier)computeValue, arg_0);
                for (Observable dep : dependencies) {
                    dep.addListener(listener);
                }
                this.previousValue = computeValue.get();
                return () -> {
                    for (Observable dep : dependencies) {
                        dep.removeListener(listener);
                    }
                };
            }

            @Override
            protected void newObserver(Consumer<? super T> subscriber) {
                subscriber.accept(this.previousValue);
            }

            private /* synthetic */ void lambda$observeInputs$0(Supplier computeValue2, Observable obs) {
                Object value = computeValue2.get();
                if (value != this.previousValue) {
                    this.previousValue = value;
                    this.emit(value);
                }
            }
        };
    }

    public static <T extends Event> EventStream<T> eventsOf(final Node node, final EventType<T> eventType) {
        return new EventStreamBase<T>(){

            @Override
            protected Subscription observeInputs() {
                EventHandler handler = this::emit;
                node.addEventHandler(eventType, handler);
                return () -> node.removeEventHandler(eventType, handler);
            }
        };
    }

    public static <T extends Event> EventStream<T> eventsOf(final Scene scene, final EventType<T> eventType) {
        return new EventStreamBase<T>(){

            @Override
            protected Subscription observeInputs() {
                EventHandler handler = this::emit;
                scene.addEventHandler(eventType, handler);
                return () -> scene.removeEventHandler(eventType, handler);
            }
        };
    }

    public static <T extends Event> EventStream<T> eventsOf(final MenuItem menuItem, final EventType<T> eventType) {
        return new EventStreamBase<T>(){

            @Override
            protected Subscription observeInputs() {
                EventHandler handler = this::emit;
                menuItem.addEventHandler(eventType, handler);
                return () -> menuItem.removeEventHandler(eventType, handler);
            }
        };
    }

    public static <T extends Event> EventStream<T> eventsOf(final Window window, final EventType<T> eventType) {
        return new EventStreamBase<T>(){

            @Override
            protected Subscription observeInputs() {
                EventHandler handler = this::emit;
                window.addEventHandler(eventType, handler);
                return () -> window.removeEventHandler(eventType, handler);
            }
        };
    }

    public static EventStream<?> ticks(final Duration interval) {
        return new EventStreamBase<Void>(){
            private final Timer timer;
            {
                this.timer = FxTimer.createPeriodic(interval, () -> this.emit(null));
            }

            @Override
            protected Subscription observeInputs() {
                this.timer.restart();
                return this.timer::stop;
            }
        };
    }

    public static EventStream<?> ticks0(final Duration interval) {
        return new EventStreamBase<Void>(){
            private final Timer timer;
            {
                this.timer = FxTimer.createPeriodic0(interval, () -> this.emit(null));
            }

            @Override
            protected Subscription observeInputs() {
                this.timer.restart();
                return this.timer::stop;
            }
        };
    }

    public static EventStream<?> ticks(final Duration interval, final ScheduledExecutorService scheduler, final Executor eventThreadExecutor) {
        return new EventStreamBase<Void>(){
            private final Timer timer;
            {
                this.timer = ScheduledExecutorServiceTimer.createPeriodic(interval, () -> this.emit(null), scheduler, eventThreadExecutor);
            }

            @Override
            protected Subscription observeInputs() {
                this.timer.restart();
                return this.timer::stop;
            }
        };
    }

    public static EventStream<?> restartableTicks(final Duration interval, final EventStream<?> impulse) {
        return new EventStreamBase<Void>(){
            private final Timer timer;
            {
                this.timer = FxTimer.createPeriodic(interval, () -> this.emit(null));
            }

            @Override
            protected Subscription observeInputs() {
                this.timer.restart();
                Subscription[] subscriptionArray = new Subscription[2];
                subscriptionArray[0] = impulse.subscribe(x2 -> this.timer.restart());
                subscriptionArray[1] = this.timer::stop;
                return Subscription.multi(subscriptionArray);
            }
        };
    }

    public static EventStream<?> restartableTicks0(final Duration interval, final EventStream<?> impulse) {
        return new EventStreamBase<Void>(){
            private final Timer timer;
            {
                this.timer = FxTimer.createPeriodic0(interval, () -> this.emit(null));
            }

            @Override
            protected Subscription observeInputs() {
                this.timer.restart();
                Subscription[] subscriptionArray = new Subscription[2];
                subscriptionArray[0] = impulse.subscribe(x2 -> this.timer.restart());
                subscriptionArray[1] = this.timer::stop;
                return Subscription.multi(subscriptionArray);
            }
        };
    }

    public static EventStream<Long> animationTicks() {
        return new EventStreamBase<Long>(){
            private final AnimationTimer timer = new AnimationTimer(){

                public void handle(long now) {
                    this.emit(now);
                }
            };

            @Override
            protected Subscription observeInputs() {
                this.timer.start();
                return () -> ((AnimationTimer)this.timer).stop();
            }
        };
    }

    public static EventStream<Long> animationFrames() {
        return EventStreams.animationTicks().accumulate(Tuples.t(0L, -1L), (state, now) -> state.map((d2, last) -> Tuples.t(last == -1L ? 0L : now - last, now))).map(t2 -> (Long)t2._1);
    }

    @SafeVarargs
    public static <T> EventStream<T> merge(final EventStream<? extends T> ... inputs) {
        return new EventStreamBase<T>(){

            @Override
            protected Subscription observeInputs() {
                return Subscription.multi(i2 -> i2.subscribe(this::emit), inputs);
            }
        };
    }

    public static <T> EventStream<T> merge(final ObservableSet<? extends EventStream<T>> set) {
        return new EventStreamBase<T>(){

            @Override
            protected Subscription observeInputs() {
                return Subscription.dynamic(set, s2 -> s2.subscribe(this::emit));
            }
        };
    }

    public static <T, U> EventStream<U> merge(final ObservableSet<? extends T> set, final Function<? super T, ? extends EventStream<U>> f2) {
        return new EventStreamBase<U>(){

            @Override
            protected Subscription observeInputs() {
                return Subscription.dynamic(set, t2 -> ((EventStream)f2.apply(t2)).subscribe(this::emit));
            }
        };
    }

    public static <L, R> Tuple2<EventStream<L>, EventStream<R>> fork(EventStream<? extends Either<L, R>> stream) {
        return Tuples.t(stream.filterMap(Either::asLeft), stream.filterMap(Either::asRight));
    }

    public static <A, B> EventStream<Tuple2<A, B>> zip(final EventStream<A> srcA, final EventStream<B> srcB) {
        return new EventStreamBase<Tuple2<A, B>>(){
            Pocket<A> pocketA = new ExclusivePocket();
            Pocket<B> pocketB = new ExclusivePocket();

            @Override
            protected Subscription observeInputs() {
                this.pocketA.clear();
                this.pocketB.clear();
                return Subscription.multi(srcA.subscribe(a2 -> {
                    this.pocketA.set(a2);
                    this.tryEmit();
                }), srcB.subscribe(b2 -> {
                    this.pocketB.set(b2);
                    this.tryEmit();
                }));
            }

            protected void tryEmit() {
                if (this.pocketA.hasValue() && this.pocketB.hasValue()) {
                    this.emit(Tuples.t(this.pocketA.getAndClear(), this.pocketB.getAndClear()));
                }
            }
        };
    }

    public static <A, B, C> EventStream<Tuple3<A, B, C>> zip(final EventStream<A> srcA, final EventStream<B> srcB, final EventStream<C> srcC) {
        return new EventStreamBase<Tuple3<A, B, C>>(){
            Pocket<A> pocketA = new ExclusivePocket();
            Pocket<B> pocketB = new ExclusivePocket();
            Pocket<C> pocketC = new ExclusivePocket();

            @Override
            protected Subscription observeInputs() {
                this.pocketA.clear();
                this.pocketB.clear();
                this.pocketC.clear();
                return Subscription.multi(srcA.subscribe(a2 -> {
                    this.pocketA.set(a2);
                    this.tryEmit();
                }), srcB.subscribe(b2 -> {
                    this.pocketB.set(b2);
                    this.tryEmit();
                }), srcC.subscribe(c2 -> {
                    this.pocketC.set(c2);
                    this.tryEmit();
                }));
            }

            protected void tryEmit() {
                if (this.pocketA.hasValue() && this.pocketB.hasValue() && this.pocketC.hasValue()) {
                    this.emit(Tuples.t(this.pocketA.getAndClear(), this.pocketB.getAndClear(), this.pocketC.getAndClear()));
                }
            }
        };
    }

    public static <A, B> EventStream<Tuple2<A, B>> combine(final EventStream<A> srcA, final EventStream<B> srcB) {
        return new EventStreamBase<Tuple2<A, B>>(){
            Pocket<A> pocketA = new Pocket();
            Pocket<B> pocketB = new Pocket();

            @Override
            protected Subscription observeInputs() {
                this.pocketA.clear();
                this.pocketB.clear();
                return Subscription.multi(srcA.subscribe(a2 -> {
                    this.pocketA.set(a2);
                    this.tryEmit();
                }), srcB.subscribe(b2 -> {
                    this.pocketB.set(b2);
                    this.tryEmit();
                }));
            }

            void tryEmit() {
                if (this.pocketA.hasValue() && this.pocketB.hasValue()) {
                    this.emit(Tuples.t(this.pocketA.get(), this.pocketB.get()));
                }
            }
        };
    }

    public static <A, B, C> EventStream<Tuple3<A, B, C>> combine(final EventStream<A> srcA, final EventStream<B> srcB, final EventStream<C> srcC) {
        return new EventStreamBase<Tuple3<A, B, C>>(){
            Pocket<A> pocketA = new Pocket();
            Pocket<B> pocketB = new Pocket();
            Pocket<C> pocketC = new Pocket();

            @Override
            protected Subscription observeInputs() {
                this.pocketA.clear();
                this.pocketB.clear();
                this.pocketC.clear();
                return Subscription.multi(srcA.subscribe(a2 -> {
                    this.pocketA.set(a2);
                    this.tryEmit();
                }), srcB.subscribe(b2 -> {
                    this.pocketB.set(b2);
                    this.tryEmit();
                }), srcC.subscribe(c2 -> {
                    this.pocketC.set(c2);
                    this.tryEmit();
                }));
            }

            void tryEmit() {
                if (this.pocketA.hasValue() && this.pocketB.hasValue() && this.pocketC.hasValue()) {
                    this.emit(Tuples.t(this.pocketA.get(), this.pocketB.get(), this.pocketC.get()));
                }
            }
        };
    }

    public static <A, B, C, D> EventStream<Tuple4<A, B, C, D>> combine(final EventStream<A> srcA, final EventStream<B> srcB, final EventStream<C> srcC, final EventStream<D> srcD) {
        return new EventStreamBase<Tuple4<A, B, C, D>>(){
            Pocket<A> pocketA = new Pocket();
            Pocket<B> pocketB = new Pocket();
            Pocket<C> pocketC = new Pocket();
            Pocket<D> pocketD = new Pocket();

            @Override
            protected Subscription observeInputs() {
                this.pocketA.clear();
                this.pocketB.clear();
                this.pocketC.clear();
                this.pocketD.clear();
                return Subscription.multi(srcA.subscribe(a2 -> {
                    this.pocketA.set(a2);
                    this.tryEmit();
                }), srcB.subscribe(b2 -> {
                    this.pocketB.set(b2);
                    this.tryEmit();
                }), srcC.subscribe(c2 -> {
                    this.pocketC.set(c2);
                    this.tryEmit();
                }), srcD.subscribe(d2 -> {
                    this.pocketD.set(d2);
                    this.tryEmit();
                }));
            }

            void tryEmit() {
                if (this.pocketA.hasValue() && this.pocketB.hasValue() && this.pocketC.hasValue() && this.pocketD.hasValue()) {
                    this.emit(Tuples.t(this.pocketA.get(), this.pocketB.get(), this.pocketC.get(), this.pocketD.get()));
                }
            }
        };
    }

    public static <A, B, C, D, E> EventStream<Tuple5<A, B, C, D, E>> combine(final EventStream<A> srcA, final EventStream<B> srcB, final EventStream<C> srcC, final EventStream<D> srcD, final EventStream<E> srcE) {
        return new EventStreamBase<Tuple5<A, B, C, D, E>>(){
            Pocket<A> pocketA = new Pocket();
            Pocket<B> pocketB = new Pocket();
            Pocket<C> pocketC = new Pocket();
            Pocket<D> pocketD = new Pocket();
            Pocket<E> pocketE = new Pocket();

            @Override
            protected Subscription observeInputs() {
                this.pocketA.clear();
                this.pocketB.clear();
                this.pocketC.clear();
                this.pocketD.clear();
                this.pocketE.clear();
                return Subscription.multi(srcA.subscribe(a2 -> {
                    this.pocketA.set(a2);
                    this.tryEmit();
                }), srcB.subscribe(b2 -> {
                    this.pocketB.set(b2);
                    this.tryEmit();
                }), srcC.subscribe(c2 -> {
                    this.pocketC.set(c2);
                    this.tryEmit();
                }), srcD.subscribe(d2 -> {
                    this.pocketD.set(d2);
                    this.tryEmit();
                }), srcE.subscribe(e2 -> {
                    this.pocketE.set(e2);
                    this.tryEmit();
                }));
            }

            void tryEmit() {
                if (this.pocketA.hasValue() && this.pocketB.hasValue() && this.pocketC.hasValue() && this.pocketD.hasValue() && this.pocketE.hasValue()) {
                    this.emit(Tuples.t(this.pocketA.get(), this.pocketB.get(), this.pocketC.get(), this.pocketD.get(), this.pocketE.get()));
                }
            }
        };
    }

    public static <A, B, C, D, E, F> EventStream<Tuple6<A, B, C, D, E, F>> combine(final EventStream<A> srcA, final EventStream<B> srcB, final EventStream<C> srcC, final EventStream<D> srcD, final EventStream<E> srcE, final EventStream<F> srcF) {
        return new EventStreamBase<Tuple6<A, B, C, D, E, F>>(){
            Pocket<A> pocketA = new Pocket();
            Pocket<B> pocketB = new Pocket();
            Pocket<C> pocketC = new Pocket();
            Pocket<D> pocketD = new Pocket();
            Pocket<E> pocketE = new Pocket();
            Pocket<F> pocketF = new Pocket();

            @Override
            protected Subscription observeInputs() {
                this.pocketA.clear();
                this.pocketB.clear();
                this.pocketC.clear();
                this.pocketD.clear();
                this.pocketE.clear();
                this.pocketF.clear();
                return Subscription.multi(srcA.subscribe(a2 -> {
                    this.pocketA.set(a2);
                    this.tryEmit();
                }), srcB.subscribe(b2 -> {
                    this.pocketB.set(b2);
                    this.tryEmit();
                }), srcC.subscribe(c2 -> {
                    this.pocketC.set(c2);
                    this.tryEmit();
                }), srcD.subscribe(d2 -> {
                    this.pocketD.set(d2);
                    this.tryEmit();
                }), srcE.subscribe(e2 -> {
                    this.pocketE.set(e2);
                    this.tryEmit();
                }), srcF.subscribe(f2 -> {
                    this.pocketF.set(f2);
                    this.tryEmit();
                }));
            }

            void tryEmit() {
                if (this.pocketA.hasValue() && this.pocketB.hasValue() && this.pocketC.hasValue() && this.pocketD.hasValue() && this.pocketE.hasValue() && this.pocketF.hasValue()) {
                    this.emit(Tuples.t(this.pocketA.get(), this.pocketB.get(), this.pocketC.get(), this.pocketD.get(), this.pocketE.get(), this.pocketF.get()));
                }
            }
        };
    }

    private static class ExclusivePocket<T>
    extends Pocket<T> {
        private ExclusivePocket() {
        }

        @Override
        public final void set(T a2) {
            if (this.hasValue()) {
                throw new IllegalStateException("Value arrived out of order: " + a2);
            }
            super.set(a2);
        }
    }

    private static class Pocket<T> {
        private boolean hasValue = false;
        private T value = null;

        private Pocket() {
        }

        public boolean hasValue() {
            return this.hasValue;
        }

        public void set(T value) {
            this.value = value;
            this.hasValue = true;
        }

        public T get() {
            return this.value;
        }

        public void clear() {
            this.hasValue = false;
            this.value = null;
        }

        public T getAndClear() {
            T res = this.get();
            this.clear();
            return res;
        }
    }

    private static final class Never<T>
    extends RigidObservable<Consumer<? super T>>
    implements EventStream<T> {
        private Never() {
        }
    }
}

