/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.concurrent.Task;
import org.reactfx.Await;
import org.reactfx.AwaitingEventStream;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.util.TriConsumer;
import org.reactfx.util.Try;

class AwaitLatest<T, F>
extends EventStreamBase<Try<T>>
implements AwaitingEventStream<Try<T>> {
    private final EventStream<F> source;
    private final EventStream<?> cancelImpulse;
    private final Consumer<F> canceller;
    private final BiConsumer<F, TriConsumer<T, Throwable, Boolean>> addCompletionHandler;
    private long revision = 0L;
    private F expectedFuture = null;
    private BooleanBinding pending = null;

    public static <T> AwaitingEventStream<Try<T>> awaitCompletionStage(EventStream<CompletionStage<T>> source, Executor clientThreadExecutor) {
        return new AwaitLatest<T, CompletionStage>(source, EventStreams.never(), future -> {}, (future, handler) -> Await.addCompletionHandler(future, handler, clientThreadExecutor));
    }

    public static <T> AwaitingEventStream<Try<T>> awaitTask(EventStream<Task<T>> source) {
        return new AwaitLatest<T, Task>(source, EventStreams.never(), Task::cancel, Await::addCompletionHandler);
    }

    public static <T> AwaitingEventStream<Try<T>> awaitCompletionStage(EventStream<CompletionStage<T>> source, EventStream<?> cancelImpulse, Executor clientThreadExecutor) {
        return new AwaitLatest<T, CompletionStage>(source, cancelImpulse, future -> {}, (future, handler) -> Await.addCompletionHandler(future, handler, clientThreadExecutor));
    }

    public static <T> AwaitingEventStream<Try<T>> awaitTask(EventStream<Task<T>> source, EventStream<?> cancelImpulse) {
        return new AwaitLatest<T, Task>(source, cancelImpulse, Task::cancel, Await::addCompletionHandler);
    }

    private AwaitLatest(EventStream<F> source, EventStream<?> cancelImpulse, Consumer<F> canceller, BiConsumer<F, TriConsumer<T, Throwable, Boolean>> addCompletionHandler) {
        this.source = source;
        this.cancelImpulse = cancelImpulse;
        this.canceller = canceller;
        this.addCompletionHandler = addCompletionHandler;
    }

    @Override
    public ObservableBooleanValue pendingProperty() {
        if (this.pending == null) {
            this.pending = new BooleanBinding(){

                protected boolean computeValue() {
                    return AwaitLatest.this.expectedFuture != null;
                }
            };
        }
        return this.pending;
    }

    @Override
    public boolean isPending() {
        return this.pending != null ? this.pending.get() : this.expectedFuture != null;
    }

    @Override
    protected Subscription observeInputs() {
        Subscription s1 = this.source.subscribe(future -> {
            long rev = this.replaceExpected(future);
            this.addCompletionHandler.accept(future, (result, error, cancelled) -> {
                if (rev == this.revision) {
                    if (!cancelled.booleanValue()) {
                        this.emit(error == null ? Try.success(result) : Try.failure(error));
                    }
                    this.setExpected(null);
                }
            });
        });
        Subscription s2 = this.cancelImpulse.subscribe(x2 -> this.replaceExpected(null));
        return s1.and(s2);
    }

    private final long replaceExpected(F newExpected) {
        ++this.revision;
        if (this.expectedFuture != null) {
            this.canceller.accept(this.expectedFuture);
        }
        this.setExpected(newExpected);
        return this.revision;
    }

    private void setExpected(F newExpected) {
        this.expectedFuture = newExpected;
        if (this.pending != null) {
            this.pending.invalidate();
        }
    }
}

