/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;

class AccumulateBetweenStream<T, A>
extends EventStreamBase<T> {
    private final EventStream<T> source;
    private final EventStream<?> ticks;
    private final Function<? super T, ? extends A> initialTransformation;
    private final BiFunction<? super A, ? super T, ? extends A> accumulation;
    private final Function<? super A, List<T>> deconstruction;
    private boolean hasValue = false;
    private A accum = null;

    public AccumulateBetweenStream(EventStream<T> source, EventStream<?> ticks, Function<? super T, ? extends A> initialTransformation, BiFunction<? super A, ? super T, ? extends A> accumulation, Function<? super A, List<T>> deconstruction) {
        this.source = source;
        this.ticks = ticks;
        this.initialTransformation = initialTransformation;
        this.accumulation = accumulation;
        this.deconstruction = deconstruction;
    }

    @Override
    protected Subscription observeInputs() {
        Subscription s1 = this.source.subscribe(this::handleEvent);
        Subscription s2 = this.ticks.subscribe(this::handleTick);
        return s1.and(s2).and(this::reset);
    }

    private void handleEvent(T event) {
        if (this.hasValue) {
            this.accum = this.accumulation.apply(this.accum, event);
        } else {
            this.accum = this.initialTransformation.apply(event);
            this.hasValue = true;
        }
    }

    private void handleTick(Object tick) {
        if (this.hasValue) {
            List<T> toEmit = this.deconstruction.apply(this.accum);
            this.reset();
            for (T t2 : toEmit) {
                this.emit(t2);
            }
        }
    }

    private void reset() {
        this.hasValue = false;
        this.accum = null;
    }
}

