/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.wellbehaved.event;

import java.util.Arrays;
import java.util.stream.Stream;
import javafx.event.Event;
import org.fxmisc.wellbehaved.event.InputHandlerMap;
import org.fxmisc.wellbehaved.event.InputMap;

class InputMapChain<E extends Event>
implements InputMap<E> {
    private final InputMap<? extends E>[] inputMaps;

    @SafeVarargs
    InputMapChain(InputMap<? extends E> ... inputMaps) {
        this.inputMaps = inputMaps;
    }

    @Override
    public void forEachEventType(InputMap.HandlerConsumer<? super E> f2) {
        InputHandlerMap<? super E> ihm = new InputHandlerMap<E>();
        for (InputMap inputMap : this.inputMaps) {
            inputMap.forEachEventType(ihm::insertAfter);
        }
        ihm.forEach(f2);
    }

    @Override
    public InputMap<E> without(InputMap<?> that) {
        if (this.equals(that)) {
            return InputMap.empty();
        }
        InputMap[] ims = (InputMap[])Stream.of(this.inputMaps).map(im -> im.without(that)).filter(im -> im != EMPTY).toArray(InputMap[]::new);
        switch (ims.length) {
            case 0: {
                return InputMap.empty();
            }
            case 1: {
                return InputMap.upCast(ims[0]);
            }
        }
        return new InputMapChain<E>(ims);
    }

    public boolean equals(Object other) {
        if (other instanceof InputMapChain) {
            InputMapChain that = (InputMapChain)other;
            return Arrays.equals(this.inputMaps, that.inputMaps);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.inputMaps);
    }
}

