/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.util;

import java.time.Duration;
import java.util.List;
import java.util.function.Consumer;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.MultiChangeBuilder;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TextChange;
import org.fxmisc.undo.UndoManager;
import org.fxmisc.undo.UndoManagerFactory;

public final class UndoUtils {
    public static final Duration DEFAULT_PREVENT_MERGE_DELAY = Duration.ofMillis(500L);

    private UndoUtils() {
        throw new IllegalStateException("UndoUtils cannot be instantiated");
    }

    public static <PS, SEG, S> UndoManager defaultUndoManager(GenericStyledArea<PS, SEG, S> genericStyledArea) {
        return genericStyledArea.isPreserveStyle() ? UndoUtils.richTextUndoManager(genericStyledArea) : UndoUtils.plainTextUndoManager(genericStyledArea);
    }

    public static <PS, SEG, S> UndoManager<List<RichTextChange<PS, SEG, S>>> richTextUndoManager(GenericStyledArea<PS, SEG, S> genericStyledArea) {
        return UndoUtils.richTextUndoManager(genericStyledArea, UndoManagerFactory.unlimitedHistoryFactory());
    }

    public static <PS, SEG, S> UndoManager<List<RichTextChange<PS, SEG, S>>> richTextUndoManager(GenericStyledArea<PS, SEG, S> genericStyledArea, Duration duration) {
        return UndoUtils.richTextUndoManager(genericStyledArea, UndoManagerFactory.unlimitedHistoryFactory(), duration);
    }

    public static <PS, SEG, S> UndoManager<List<RichTextChange<PS, SEG, S>>> richTextUndoManager(GenericStyledArea<PS, SEG, S> genericStyledArea, UndoManagerFactory undoManagerFactory) {
        return UndoUtils.richTextUndoManager(genericStyledArea, undoManagerFactory, DEFAULT_PREVENT_MERGE_DELAY);
    }

    public static <PS, SEG, S> UndoManager<List<RichTextChange<PS, SEG, S>>> richTextUndoManager(GenericStyledArea<PS, SEG, S> genericStyledArea, UndoManagerFactory undoManagerFactory, Duration duration) {
        return undoManagerFactory.createMultiChangeUM(genericStyledArea.multiRichChanges(), TextChange::invert, UndoUtils.applyMultiRichTextChange(genericStyledArea), TextChange::mergeWith, TextChange::isIdentity, duration);
    }

    public static <PS, SEG, S> UndoManager<List<PlainTextChange>> plainTextUndoManager(GenericStyledArea<PS, SEG, S> genericStyledArea) {
        return UndoUtils.plainTextUndoManager(genericStyledArea, DEFAULT_PREVENT_MERGE_DELAY);
    }

    public static <PS, SEG, S> UndoManager<List<PlainTextChange>> plainTextUndoManager(GenericStyledArea<PS, SEG, S> genericStyledArea, Duration duration) {
        return UndoUtils.plainTextUndoManager(genericStyledArea, UndoManagerFactory.unlimitedHistoryFactory(), duration);
    }

    public static <PS, SEG, S> UndoManager<List<PlainTextChange>> plainTextUndoManager(GenericStyledArea<PS, SEG, S> genericStyledArea, UndoManagerFactory undoManagerFactory) {
        return UndoUtils.plainTextUndoManager(genericStyledArea, undoManagerFactory, DEFAULT_PREVENT_MERGE_DELAY);
    }

    public static <PS, SEG, S> UndoManager<List<PlainTextChange>> plainTextUndoManager(GenericStyledArea<PS, SEG, S> genericStyledArea, UndoManagerFactory undoManagerFactory, Duration duration) {
        return undoManagerFactory.createMultiChangeUM(genericStyledArea.multiPlainChanges(), TextChange::invert, UndoUtils.applyMultiPlainTextChange(genericStyledArea), TextChange::mergeWith, TextChange::isIdentity, duration);
    }

    public static <PS, SEG, S> Consumer<PlainTextChange> applyPlainTextChange(GenericStyledArea<PS, SEG, S> genericStyledArea) {
        return plainTextChange -> genericStyledArea.replaceText(plainTextChange.getPosition(), plainTextChange.getRemovalEnd(), (String)plainTextChange.getInserted());
    }

    public static <PS, SEG, S> Consumer<RichTextChange<PS, SEG, S>> applyRichTextChange(GenericStyledArea<PS, SEG, S> genericStyledArea) {
        return richTextChange -> genericStyledArea.replace(richTextChange.getPosition(), richTextChange.getRemovalEnd(), (StyledDocument)richTextChange.getInserted());
    }

    public static <PS, SEG, S> Consumer<List<PlainTextChange>> applyMultiPlainTextChange(GenericStyledArea<PS, SEG, S> genericStyledArea) {
        return list -> {
            MultiChangeBuilder multiChangeBuilder = genericStyledArea.createMultiChange(list.size());
            for (PlainTextChange plainTextChange : list) {
                multiChangeBuilder.replaceTextAbsolutely(plainTextChange.getPosition(), plainTextChange.getRemovalEnd(), (String)plainTextChange.getInserted());
            }
            multiChangeBuilder.commit();
        };
    }

    public static <PS, SEG, S> Consumer<List<RichTextChange<PS, SEG, S>>> applyMultiRichTextChange(GenericStyledArea<PS, SEG, S> genericStyledArea) {
        return list -> {
            MultiChangeBuilder multiChangeBuilder = genericStyledArea.createMultiChange(list.size());
            for (RichTextChange richTextChange : list) {
                multiChangeBuilder.replaceAbsolutely(richTextChange.getPosition(), richTextChange.getRemovalEnd(), (StyledDocument)richTextChange.getInserted());
            }
            multiChangeBuilder.commit();
        };
    }
}

