/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import org.reactfx.Subscription;

public class SubscribeableContentsObsSet<E>
extends AbstractSet<E>
implements ObservableSet<E> {
    private final List<Function<? super E, Subscription>> subscribers = new LinkedList<Function<? super E, Subscription>>();
    private final List<SetChangeListener<? super E>> changeListeners = new LinkedList<SetChangeListener<? super E>>();
    private final List<InvalidationListener> invalidationListeners = new LinkedList<InvalidationListener>();
    private final Map<E, List<Subscription>> map;

    public SubscribeableContentsObsSet() {
        this(null);
    }

    public SubscribeableContentsObsSet(Comparator<? super E> comparator) {
        this.map = new TreeMap<E, List<Subscription>>(comparator);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean add(E e2) {
        Objects.requireNonNull(e2, "Cannot add a null object to this list");
        if (this.map.containsKey(e2)) {
            return false;
        }
        ArrayList arrayList = new ArrayList(1);
        this.subscribers.stream().map(function -> (Subscription)function.apply(e2)).forEach(arrayList::add);
        this.map.put(e2, arrayList);
        this.invalidateSet();
        this.fireElementAdded(e2);
        return true;
    }

    @Override
    public boolean remove(Object object) {
        List<Subscription> list = this.map.remove(object);
        if (list == null) {
            return false;
        }
        list.forEach(Subscription::unsubscribe);
        this.invalidateSet();
        this.fireElementRemoved(object);
        return true;
    }

    public Subscription addSubscriber(Function<? super E, Subscription> function) {
        Objects.requireNonNull(function);
        this.subscribers.add(function);
        ArrayList<E> arrayList = new ArrayList<E>(this.map.keySet());
        arrayList.forEach(object -> {
            List<Subscription> list = this.map.get(object);
            Subscription subscription = (Subscription)function.apply((E)object);
            list.add(subscription);
            this.map.put(object, list);
        });
        return () -> this.removeSubscriber(function);
    }

    public Subscription addChangeListener(SetChangeListener<? super E> setChangeListener) {
        this.addListener(setChangeListener);
        return () -> this.removeListener(setChangeListener);
    }

    public Subscription addInvalidationListener(InvalidationListener invalidationListener) {
        this.addListener(invalidationListener);
        return () -> this.removeListener(invalidationListener);
    }

    public void addListener(SetChangeListener<? super E> setChangeListener) {
        this.changeListeners.add(setChangeListener);
    }

    public void removeListener(SetChangeListener<? super E> setChangeListener) {
        this.changeListeners.remove(setChangeListener);
    }

    public void addListener(InvalidationListener invalidationListener) {
        this.invalidationListeners.add(invalidationListener);
    }

    public void removeListener(InvalidationListener invalidationListener) {
        this.invalidationListeners.remove(invalidationListener);
    }

    private void invalidateSet() {
        this.invalidationListeners.forEach(invalidationListener -> invalidationListener.invalidated((Observable)this));
    }

    private void removeSubscriber(Function<? super E, Subscription> function) {
        int n2 = -1;
        int n3 = 0;
        Iterator<Function<E, Subscription>> iterator = this.subscribers.iterator();
        while (iterator.hasNext() && n2 == -1) {
            Function<? super E, Subscription> function2 = iterator.next();
            if (function2 == function) {
                iterator.remove();
                n2 = n3;
                continue;
            }
            ++n3;
        }
        int n4 = n2;
        ArrayList<E> arrayList = new ArrayList<E>(this.map.keySet());
        arrayList.forEach(object -> this.map.get(object).remove(n4).unsubscribe());
    }

    private void fireElementAdded(final E e2) {
        SetChangeListener.Change change = new SetChangeListener.Change<E>(this){

            public boolean wasAdded() {
                return true;
            }

            public boolean wasRemoved() {
                return false;
            }

            public E getElementAdded() {
                return e2;
            }

            public E getElementRemoved() {
                return null;
            }
        };
        this.changeListeners.forEach(arg_0 -> SubscribeableContentsObsSet.lambda$fireElementAdded$7((SetChangeListener.Change)change, arg_0));
    }

    private void fireElementRemoved(final E e2) {
        SetChangeListener.Change change = new SetChangeListener.Change<E>(this){

            public boolean wasAdded() {
                return false;
            }

            public boolean wasRemoved() {
                return true;
            }

            public E getElementAdded() {
                return null;
            }

            public E getElementRemoved() {
                return e2;
            }
        };
        this.changeListeners.forEach(arg_0 -> SubscribeableContentsObsSet.lambda$fireElementRemoved$8((SetChangeListener.Change)change, arg_0));
    }

    private static /* synthetic */ void lambda$fireElementRemoved$8(SetChangeListener.Change change, SetChangeListener setChangeListener) {
        setChangeListener.onChanged(change);
    }

    private static /* synthetic */ void lambda$fireElementAdded$7(SetChangeListener.Change change, SetChangeListener setChangeListener) {
        setChangeListener.onChanged(change);
    }
}

