/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import org.fxmisc.richtext.model.TwoDimensional;

public class TwoLevelNavigator
implements TwoDimensional {
    private final IntSupplier elemCount;
    private final IntUnaryOperator elemLength;

    public TwoLevelNavigator(IntSupplier intSupplier, IntUnaryOperator intUnaryOperator) {
        this.elemCount = intSupplier;
        this.elemLength = intUnaryOperator;
    }

    @Override
    public TwoDimensional.Position position(int n2, int n3) {
        return new Pos(n2, n3);
    }

    @Override
    public TwoDimensional.Position offsetToPosition(int n2, TwoDimensional.Bias bias) {
        return this.position(0, 0).offsetBy(n2, bias);
    }

    private class Pos
    implements TwoDimensional.Position {
        private final int major;
        private final int minor;

        private Pos(int n2, int n3) {
            this.major = n2;
            this.minor = n3;
        }

        public String toString() {
            return "(" + this.major + ", " + this.minor + ")";
        }

        @Override
        public boolean sameAs(TwoDimensional.Position position) {
            return this.getTargetObject() == position.getTargetObject() && this.major == position.getMajor() && this.minor == position.getMinor();
        }

        @Override
        public TwoDimensional getTargetObject() {
            return TwoLevelNavigator.this;
        }

        @Override
        public int getMajor() {
            return this.major;
        }

        @Override
        public int getMinor() {
            return this.minor;
        }

        @Override
        public TwoDimensional.Position clamp() {
            if (this.major == TwoLevelNavigator.this.elemCount.getAsInt() - 1) {
                int n2 = TwoLevelNavigator.this.elemLength.applyAsInt(this.major);
                if (this.minor < n2) {
                    return this;
                }
                return new Pos(this.major, n2 - 1);
            }
            return this;
        }

        @Override
        public TwoDimensional.Position offsetBy(int n2, TwoDimensional.Bias bias) {
            if (n2 > 0) {
                return this.forward(n2, bias);
            }
            if (n2 < 0) {
                return this.backward(-n2, bias);
            }
            if (this.minor == 0 && this.major > 1 && bias == TwoDimensional.Bias.Backward) {
                return new Pos(this.major - 1, TwoLevelNavigator.this.elemLength.applyAsInt(this.major - 1));
            }
            if (this.minor == TwoLevelNavigator.this.elemLength.applyAsInt(this.major) && this.major < TwoLevelNavigator.this.elemCount.getAsInt() - 1 && bias == TwoDimensional.Bias.Forward) {
                return new Pos(this.major + 1, 0);
            }
            return this;
        }

        @Override
        public int toOffset() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.major; ++i2) {
                n2 += TwoLevelNavigator.this.elemLength.applyAsInt(i2);
            }
            return n2 + this.minor;
        }

        private TwoDimensional.Position forward(int n2, TwoDimensional.Bias bias) {
            n2 += this.minor;
            int n3 = this.major;
            int n4 = TwoLevelNavigator.this.elemLength.applyAsInt(n3);
            int n5 = TwoLevelNavigator.this.elemCount.getAsInt();
            while (n3 < n5 - 1) {
                if (n2 < n4 || n2 == n4 && bias == TwoDimensional.Bias.Backward) {
                    return new Pos(n3, n2);
                }
                n2 -= n4;
                n4 = TwoLevelNavigator.this.elemLength.applyAsInt(++n3);
            }
            return new Pos(n5 - 1, n2);
        }

        private TwoDimensional.Position backward(int n2, TwoDimensional.Bias bias) {
            int n3 = this.minor;
            int n4 = this.major;
            while (n4 > 0) {
                if (n2 < n3 || n2 == n3 && bias == TwoDimensional.Bias.Forward) {
                    return new Pos(n4, n3 - n2);
                }
                n2 -= n3;
                n3 = TwoLevelNavigator.this.elemLength.applyAsInt(--n4);
            }
            if (n2 < n3) {
                return new Pos(0, n3 - n2);
            }
            return new Pos(0, 0);
        }
    }
}

