/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.Objects;
import java.util.Optional;

public abstract class TextChange<S, Self extends TextChange<S, Self>> {
    protected final int position;
    protected final S removed;
    protected final S inserted;

    public TextChange(int n2, S s2, S s3) {
        this.position = n2;
        this.removed = s2;
        this.inserted = s3;
    }

    public int getPosition() {
        return this.position;
    }

    public S getRemoved() {
        return this.removed;
    }

    public S getInserted() {
        return this.inserted;
    }

    public Self invert() {
        return this.create(this.position, this.inserted, this.removed);
    }

    public int getRemovalEnd() {
        return this.position + this.removedLength();
    }

    public int getInsertionEnd() {
        return this.position + this.insertedLength();
    }

    public int getNetLength() {
        return this.insertedLength() - this.removedLength();
    }

    protected abstract int removedLength();

    protected abstract int insertedLength();

    protected abstract S concat(S var1, S var2);

    protected abstract S sub(S var1, int var2, int var3);

    protected abstract Self create(int var1, S var2, S var3);

    public final boolean isIdentity() {
        return this.removed.equals(this.inserted);
    }

    public Optional<Self> mergeWith(Self Self) {
        if (((TextChange)Self).position == this.position + this.insertedLength()) {
            S s2 = this.concat(this.removed, ((TextChange)Self).removed);
            S s3 = this.concat(this.inserted, ((TextChange)Self).inserted);
            return Optional.of(this.create(this.position, s2, s3));
        }
        if (((TextChange)Self).position + ((TextChange)Self).removedLength() == this.position + this.insertedLength()) {
            if (this.position <= ((TextChange)Self).position) {
                S s4 = this.concat(this.sub(this.inserted, 0, ((TextChange)Self).position - this.position), ((TextChange)Self).inserted);
                return Optional.of(this.create(this.position, this.removed, s4));
            }
            S s5 = this.concat(this.sub(((TextChange)Self).removed, 0, this.position - ((TextChange)Self).position), this.removed);
            return Optional.of(this.create(((TextChange)Self).position, s5, ((TextChange)Self).inserted));
        }
        return Optional.empty();
    }

    public boolean equals(Object object) {
        if (object instanceof TextChange) {
            TextChange textChange = (TextChange)object;
            return Objects.equals(this.position, textChange.position) && Objects.equals(this.removed, textChange.removed) && Objects.equals(this.inserted, textChange.inserted);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.position, this.removed, this.inserted);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{\n\tposition: " + this.position + "\n\tremoved: " + this.removed + "\n\tinserted: " + this.inserted + "\n}";
    }
}

