/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fxmisc.richtext.model.Codec;

interface SuperCodec<S, T extends S>
extends Codec<T> {
    public void encodeSuper(DataOutputStream var1, S var2) throws IOException;

    @Override
    default public void encode(DataOutputStream dataOutputStream, T t2) throws IOException {
        this.encodeSuper(dataOutputStream, t2);
    }

    public static <S, U extends S, T extends U> SuperCodec<S, U> upCast(SuperCodec<S, T> superCodec) {
        return superCodec;
    }

    public static <T> SuperCodec<Collection<T>, List<T>> collectionListCodec(final Codec<T> codec) {
        return new SuperCodec<Collection<T>, List<T>>(){

            @Override
            public String getName() {
                return "list<" + codec.getName() + ">";
            }

            @Override
            public void encodeSuper(DataOutputStream dataOutputStream, Collection<T> collection) throws IOException {
                dataOutputStream.writeInt(collection.size());
                for (Object t2 : collection) {
                    codec.encode(dataOutputStream, t2);
                }
            }

            @Override
            public List<T> decode(DataInputStream dataInputStream) throws IOException {
                int n2 = dataInputStream.readInt();
                ArrayList arrayList = new ArrayList(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object t2 = codec.decode(dataInputStream);
                    arrayList.add(t2);
                }
                return arrayList;
            }
        };
    }
}

