/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.ArrayList;
import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBase;
import org.fxmisc.richtext.model.TwoDimensional;

class SubSpans<S>
extends StyleSpansBase<S> {
    private final StyleSpans<S> original;
    private final int firstIdxInOrig;
    private final int spanCount;
    private final StyleSpan<S> firstSpan;
    private final StyleSpan<S> lastSpan;
    int length = -1;

    public SubSpans(StyleSpans<S> styleSpans, TwoDimensional.Position position, TwoDimensional.Position position2) {
        this.original = styleSpans;
        this.firstIdxInOrig = position.getMajor();
        this.spanCount = position2.getMajor() - position.getMajor() + 1;
        if (this.spanCount == 1) {
            StyleSpan<S> styleSpan = styleSpans.getStyleSpan(this.firstIdxInOrig);
            int n2 = position2.getMinor() - position.getMinor();
            this.lastSpan = new StyleSpan<S>(styleSpan.getStyle(), n2);
            this.firstSpan = this.lastSpan;
        } else {
            StyleSpan<S> styleSpan = styleSpans.getStyleSpan(this.firstIdxInOrig);
            int n3 = styleSpan.getLength() - position.getMinor();
            this.firstSpan = new StyleSpan<S>(styleSpan.getStyle(), n3);
            StyleSpan<S> styleSpan2 = styleSpans.getStyleSpan(position2.getMajor());
            this.lastSpan = new StyleSpan<S>(styleSpan2.getStyle(), position2.getMinor());
        }
    }

    @Override
    public int length() {
        if (this.length == -1) {
            this.length = 0;
            for (StyleSpan styleSpan : this) {
                this.length += styleSpan.getLength();
            }
        }
        return this.length;
    }

    @Override
    public int getSpanCount() {
        return this.spanCount;
    }

    @Override
    public StyleSpan<S> getStyleSpan(int n2) {
        if (n2 == 0) {
            return this.firstSpan;
        }
        if (n2 == this.spanCount - 1) {
            return this.lastSpan;
        }
        if (n2 < 0 || n2 >= this.spanCount) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return this.original.getStyleSpan(this.firstIdxInOrig + n2);
    }

    public String toString() {
        ArrayList<StyleSpan<S>> arrayList = new ArrayList<StyleSpan<S>>(this.spanCount);
        for (int i2 = 0; i2 < this.spanCount; ++i2) {
            arrayList.add(this.getStyleSpan(i2));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SubSpans(length=").append(this.length).append(" spanCount=").append(this.getSpanCount()).append(" spans=").append(arrayList).append(")");
        return stringBuilder.toString();
    }
}

