/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.fxmisc.richtext.model.TwoDimensional;

public interface StyledDocument<PS, SEG, S>
extends TwoDimensional {
    public int length();

    public String getText();

    public List<Paragraph<PS, SEG, S>> getParagraphs();

    public StyledDocument<PS, SEG, S> concat(StyledDocument<PS, SEG, S> var1);

    public StyledDocument<PS, SEG, S> subSequence(int var1, int var2);

    default public String getText(IndexRange indexRange) {
        return this.getText(indexRange.getStart(), indexRange.getEnd());
    }

    default public String getText(int n2, int n3) {
        return this.subSequence(n2, n3).getText();
    }

    default public String getText(int n2) {
        return this.getParagraph(n2).getText();
    }

    default public Paragraph<PS, SEG, S> getParagraph(int n2) {
        return this.getParagraphs().get(n2);
    }

    default public int getParagraphLength(int n2) {
        return this.getParagraph(n2).length();
    }

    default public StyledDocument<PS, SEG, S> subSequence(IndexRange indexRange) {
        return this.subSequence(indexRange.getStart(), indexRange.getEnd());
    }

    default public StyledDocument<PS, SEG, S> subDocument(int n2) {
        return new ReadOnlyStyledDocument<PS, SEG, S>(Collections.singletonList(this.getParagraphs().get(n2)));
    }

    default public char charAt(int n2) {
        TwoDimensional.Position position = this.offsetToPosition(n2, TwoDimensional.Bias.Forward);
        return this.getParagraphs().get(position.getMajor()).charAt(position.getMinor());
    }

    default public S getStyleOfChar(int n2) {
        TwoDimensional.Position position = this.offsetToPosition(n2, TwoDimensional.Bias.Forward);
        int n3 = position.getMajor();
        int n4 = position.getMinor();
        return this.getParagraphs().get(n3).getStyleOfChar(n4);
    }

    default public S getStyleOfChar(int n2, int n3) {
        return this.getParagraphs().get(n2).getStyleOfChar(n3);
    }

    default public S getStyleAtPosition(int n2) {
        TwoDimensional.Position position = this.offsetToPosition(n2, TwoDimensional.Bias.Forward);
        return this.getStyleAtPosition(position.getMajor(), position.getMinor());
    }

    default public S getStyleAtPosition(int n2, int n3) {
        return this.getParagraphs().get(n2).getStyleAtPosition(n3);
    }

    default public PS getParagraphStyle(int n2) {
        return this.getParagraphs().get(n2).getParagraphStyle();
    }

    default public PS getParagraphStyleAtPosition(int n2) {
        TwoDimensional.Position position = this.offsetToPosition(n2, TwoDimensional.Bias.Forward);
        return this.getParagraphStyle(position.getMajor());
    }

    default public IndexRange getStyleRangeAtPosition(int n2) {
        TwoDimensional.Position position = this.offsetToPosition(n2, TwoDimensional.Bias.Forward);
        int n3 = position.getMajor();
        int n4 = position.getMinor();
        return this.getParagraphs().get(n3).getStyleRangeAtPosition(n4);
    }

    default public IndexRange getStyleRangeAtPosition(int n2, int n3) {
        return this.getParagraphs().get(n2).getStyleRangeAtPosition(n3);
    }

    default public StyleSpans<S> getStyleSpans(int n2, int n3) {
        Object object;
        Paragraph<PS, SEG, S> paragraph;
        TwoDimensional.Position position = this.offsetToPosition(n2, TwoDimensional.Bias.Forward);
        TwoDimensional.Position position2 = n3 == n2 ? position : position.offsetBy(n3 - n2, TwoDimensional.Bias.Backward);
        int n4 = position.getMajor();
        int n5 = position2.getMajor();
        int n6 = n5 - n4 + 1;
        ArrayList arrayList = new ArrayList(n6);
        if (n4 == n5) {
            paragraph = this.getParagraphs().get(n4);
            arrayList.add(paragraph.getStyleSpans(position.getMinor(), position2.getMinor()));
        } else {
            paragraph = this.getParagraphs().get(n4);
            arrayList.add(paragraph.getStyleSpans(position.getMinor(), paragraph.length() + 1));
            for (int i2 = n4 + 1; i2 < n5; ++i2) {
                Paragraph<PS, SEG, S> paragraph2 = this.getParagraphs().get(i2);
                arrayList.add(paragraph2.getStyleSpans(0, paragraph2.length() + 1));
            }
            object = this.getParagraphs().get(n5);
            arrayList.add(((Paragraph)object).getStyleSpans(0, position2.getMinor()));
        }
        int n7 = arrayList.stream().mapToInt(StyleSpans::getSpanCount).sum();
        object = new StyleSpansBuilder(n7);
        for (StyleSpans styleSpans : arrayList) {
            for (StyleSpan styleSpan : styleSpans) {
                ((StyleSpansBuilder)object).add(styleSpan);
            }
        }
        return ((StyleSpansBuilder)object).create();
    }

    default public StyleSpans<S> getStyleSpans(int n2) {
        return this.getParagraphs().get(n2).getStyleSpans();
    }

    default public StyleSpans<S> getStyleSpans(int n2, int n3, int n4) {
        return this.getParagraphs().get(n2).getStyleSpans(n3, n4);
    }

    default public int getAbsolutePosition(int n2, int n3) {
        int n4 = this.position(n2, n3).toOffset();
        if (n4 < 0) {
            throw new IndexOutOfBoundsException(String.format("Negative index! Out of bounds by %s.", 0 - n4));
        }
        if (this.length() < n4) {
            throw new IndexOutOfBoundsException(String.format("Out of bounds by %s. Area Length: %s", n4 - this.length(), this.length()));
        }
        return n4;
    }
}

