/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBase;

public class StyleSpansBuilder<S> {
    private boolean created = false;
    private final ArrayList<StyleSpan<S>> spans;

    static <S> StyleSpans<S> overlay(StyleSpans<S> styleSpans, StyleSpans<S> styleSpans2, BiFunction<? super S, ? super S, ? extends S> biFunction) {
        StyleSpansBuilder<S> styleSpansBuilder = new StyleSpansBuilder<S>(styleSpans.getSpanCount() + styleSpans2.getSpanCount());
        Iterator<StyleSpan<S>> iterator = styleSpans.iterator();
        Iterator<StyleSpan<S>> iterator2 = styleSpans2.iterator();
        StyleSpan<S> styleSpan = iterator.next();
        StyleSpan<S> styleSpan2 = iterator2.next();
        while (true) {
            int n2;
            int n3;
            if ((n3 = styleSpan.getLength()) == (n2 = styleSpan2.getLength())) {
                styleSpansBuilder.add(biFunction.apply(styleSpan.getStyle(), styleSpan2.getStyle()), n3);
                if (!iterator.hasNext()) {
                    return styleSpansBuilder.addAll(iterator2).create();
                }
                if (!iterator2.hasNext()) {
                    return styleSpansBuilder.addAll(iterator).create();
                }
                styleSpan = iterator.next();
                styleSpan2 = iterator2.next();
                continue;
            }
            if (n3 < n2) {
                styleSpansBuilder.add(biFunction.apply(styleSpan.getStyle(), styleSpan2.getStyle()), n3);
                styleSpan2 = new StyleSpan<S>(styleSpan2.getStyle(), n2 - n3);
                if (iterator.hasNext()) {
                    styleSpan = iterator.next();
                    continue;
                }
                return styleSpansBuilder.add(styleSpan2).addAll(iterator2).create();
            }
            styleSpansBuilder.add(biFunction.apply(styleSpan.getStyle(), styleSpan2.getStyle()), n2);
            styleSpan = new StyleSpan<S>(styleSpan.getStyle(), n3 - n2);
            if (!iterator2.hasNext()) break;
            styleSpan2 = iterator2.next();
        }
        return styleSpansBuilder.add(styleSpan).addAll(iterator).create();
    }

    public StyleSpansBuilder(int n2) {
        this.spans = new ArrayList(n2);
    }

    public StyleSpansBuilder() {
        this.spans = new ArrayList();
    }

    public StyleSpansBuilder<S> add(StyleSpan<S> styleSpan) {
        this.ensureNotCreated();
        this._add(styleSpan);
        return this;
    }

    public StyleSpansBuilder<S> add(S s2, int n2) {
        return this.add(new StyleSpan<S>(s2, n2));
    }

    public StyleSpansBuilder<S> addAll(Collection<? extends StyleSpan<S>> collection) {
        return this.addAll(collection, collection.size());
    }

    public StyleSpansBuilder<S> addAll(Iterable<? extends StyleSpan<S>> iterable, int n2) {
        this.spans.ensureCapacity(this.spans.size() + n2);
        return this.addAll(iterable);
    }

    public StyleSpansBuilder<S> addAll(Iterable<? extends StyleSpan<S>> iterable) {
        this.ensureNotCreated();
        for (StyleSpan<S> styleSpan : iterable) {
            this._add(styleSpan);
        }
        return this;
    }

    public StyleSpansBuilder<S> addAll(Iterator<? extends StyleSpan<S>> iterator) {
        this.ensureNotCreated();
        while (iterator.hasNext()) {
            this._add(iterator.next());
        }
        return this;
    }

    public StyleSpans<S> create() {
        this.ensureNotCreated();
        if (this.spans.isEmpty()) {
            throw new IllegalStateException("No spans have been added");
        }
        this.created = true;
        return new StyleSpansImpl<S>(Collections.unmodifiableList(this.spans));
    }

    private void _add(StyleSpan<S> styleSpan) {
        if (this.spans.isEmpty()) {
            this.spans.add(styleSpan);
        } else if (styleSpan.getLength() > 0) {
            if (this.spans.size() == 1 && this.spans.get(0).getLength() == 0) {
                this.spans.set(0, styleSpan);
            } else {
                StyleSpan<S> styleSpan2 = this.spans.get(this.spans.size() - 1);
                if (styleSpan2.getStyle().equals(styleSpan.getStyle())) {
                    this.spans.set(this.spans.size() - 1, new StyleSpan<S>(styleSpan.getStyle(), styleSpan2.getLength() + styleSpan.getLength()));
                } else {
                    this.spans.add(styleSpan);
                }
            }
        }
    }

    private void ensureNotCreated() {
        if (this.created) {
            throw new IllegalStateException("Cannot reuse StyleRangesBuilder after StyleRanges have been created.");
        }
    }

    private static class StyleSpansImpl<S>
    extends StyleSpansBase<S> {
        private final List<StyleSpan<S>> spans;
        private int length = -1;

        StyleSpansImpl(List<StyleSpan<S>> list) {
            this.spans = list;
        }

        @Override
        public Iterator<StyleSpan<S>> iterator() {
            return this.spans.iterator();
        }

        @Override
        public int length() {
            if (this.length == -1) {
                this.length = this.spans.stream().mapToInt(StyleSpan::getLength).sum();
            }
            return this.length;
        }

        @Override
        public int getSpanCount() {
            return this.spans.size();
        }

        @Override
        public StyleSpan<S> getStyleSpan(int n2) {
            return this.spans.get(n2);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("StyleSpans(length=").append(this.length()).append(" spanCount=").append(this.getSpanCount()).append(" spans=").append(this.spans).append(")");
            return stringBuilder.toString();
        }
    }
}

