/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.fxmisc.richtext.model.AppendedSpans;
import org.fxmisc.richtext.model.PrependedSpans;
import org.fxmisc.richtext.model.SingletonSpans;
import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.fxmisc.richtext.model.SubSpans;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.richtext.model.UpdatedSpans;

public interface StyleSpans<S>
extends Iterable<StyleSpan<S>>,
TwoDimensional {
    public static <S> StyleSpans<S> singleton(S s2, int n2) {
        return StyleSpans.singleton(new StyleSpan<S>(s2, n2));
    }

    public static <S> StyleSpans<S> singleton(StyleSpan<S> styleSpan) {
        return new SingletonSpans<S>(styleSpan);
    }

    public int length();

    public int getSpanCount();

    public StyleSpan<S> getStyleSpan(int var1);

    public boolean equals(Object var1);

    @Override
    default public Iterator<StyleSpan<S>> iterator() {
        return new Iterator<StyleSpan<S>>(){
            private int nextToReturn = 0;
            private final int spanCount = StyleSpans.this.getSpanCount();

            @Override
            public boolean hasNext() {
                return this.nextToReturn < this.spanCount;
            }

            @Override
            public StyleSpan<S> next() {
                return StyleSpans.this.getStyleSpan(this.nextToReturn++);
            }
        };
    }

    default public StyleSpans<S> append(S s2, int n2) {
        return this.append(new StyleSpan<S>(s2, n2));
    }

    default public StyleSpans<S> append(StyleSpan<S> styleSpan) {
        if (styleSpan.getLength() == 0) {
            return this;
        }
        if (this.length() == 0) {
            return StyleSpans.singleton(styleSpan);
        }
        int n2 = this.getSpanCount() - 1;
        StyleSpan<S> styleSpan2 = this.getStyleSpan(n2);
        if (Objects.equals(styleSpan2.getStyle(), styleSpan.getStyle())) {
            StyleSpan<S> styleSpan3 = new StyleSpan<S>(styleSpan.getStyle(), styleSpan2.getLength() + styleSpan.getLength());
            return new UpdatedSpans<S>(this, n2, styleSpan3);
        }
        return new AppendedSpans<S>(this, styleSpan);
    }

    default public StyleSpans<S> prepend(S s2, int n2) {
        return this.prepend(new StyleSpan<S>(s2, n2));
    }

    default public StyleSpans<S> prepend(StyleSpan<S> styleSpan) {
        if (styleSpan.getLength() == 0) {
            return this;
        }
        if (this.length() == 0) {
            return StyleSpans.singleton(styleSpan);
        }
        StyleSpan<S> styleSpan2 = this.getStyleSpan(0);
        if (Objects.equals(styleSpan.getStyle(), styleSpan2.getStyle())) {
            StyleSpan<S> styleSpan3 = new StyleSpan<S>(styleSpan.getStyle(), styleSpan.getLength() + styleSpan2.getLength());
            return new UpdatedSpans<S>(this, 0, styleSpan3);
        }
        return new PrependedSpans<S>(this, styleSpan);
    }

    default public StyleSpans<S> subView(int n2, int n3) {
        TwoDimensional.Position position = this.offsetToPosition(n2, TwoDimensional.Bias.Forward);
        TwoDimensional.Position position2 = n3 > n2 ? position.offsetBy(n3 - n2, TwoDimensional.Bias.Backward) : position;
        return this.subView(position, position2);
    }

    default public StyleSpans<S> subView(TwoDimensional.Position position, TwoDimensional.Position position2) {
        return new SubSpans(this, position, position2);
    }

    default public StyleSpans<S> concat(StyleSpans<S> styleSpans) {
        StyleSpansBuilder<S> styleSpansBuilder;
        if (styleSpans.length() == 0) {
            return this;
        }
        if (this.length() == 0) {
            return styleSpans;
        }
        int n2 = this.getSpanCount();
        int n3 = styleSpans.getSpanCount();
        StyleSpan<S> styleSpan = this.getStyleSpan(n2 - 1);
        StyleSpan<S> styleSpan2 = styleSpans.getStyleSpan(0);
        if (Objects.equals(styleSpan.getStyle(), styleSpan2.getStyle())) {
            int n4;
            styleSpansBuilder = new StyleSpansBuilder(n2 + n3 - 1);
            for (n4 = 0; n4 < n2 - 1; ++n4) {
                styleSpansBuilder.add(this.getStyleSpan(n4));
            }
            styleSpansBuilder.add(styleSpan.getStyle(), styleSpan.getLength() + styleSpan2.getLength());
            for (n4 = 1; n4 < n3; ++n4) {
                styleSpansBuilder.add(styleSpans.getStyleSpan(n4));
            }
        } else {
            styleSpansBuilder = new StyleSpansBuilder<S>(n2 + n3);
            styleSpansBuilder.addAll(this, n2);
            styleSpansBuilder.addAll(styleSpans, n3);
        }
        return styleSpansBuilder.create();
    }

    default public StyleSpans<S> mapStyles(UnaryOperator<S> unaryOperator) {
        StyleSpansBuilder styleSpansBuilder = new StyleSpansBuilder(this.getSpanCount());
        for (StyleSpan<S> styleSpan : this) {
            styleSpansBuilder.add(unaryOperator.apply(styleSpan.getStyle()), styleSpan.getLength());
        }
        return styleSpansBuilder.create();
    }

    default public StyleSpans<S> overlay(StyleSpans<S> styleSpans, BiFunction<? super S, ? super S, ? extends S> biFunction) {
        return StyleSpansBuilder.overlay(this, styleSpans, biFunction);
    }

    default public Stream<S> styleStream() {
        return this.stream().map(StyleSpan::getStyle);
    }

    default public Stream<StyleSpan<S>> stream() {
        Spliterator spliterator = new Spliterator<StyleSpan<S>>(){
            private final Iterator<StyleSpan<S>> iterator;
            {
                this.iterator = StyleSpans.this.iterator();
            }

            @Override
            public boolean tryAdvance(Consumer<? super StyleSpan<S>> consumer) {
                if (this.iterator.hasNext()) {
                    consumer.accept(this.iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<StyleSpan<S>> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return StyleSpans.this.getSpanCount();
            }

            @Override
            public int characteristics() {
                return 1088;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }
}

